/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProviderException;
import java.security.SecureRandomSpi;
import sun.security.provider.SecureRandom;

public final class NativePRNG
extends SecureRandomSpi {
    private static final long serialVersionUID = -6599091113397072932L;
    private static final String NAME_RANDOM = "/dev/srandom";
    private static final String NAME_URANDOM = "/dev/urandom";
    private static final RandomIO INSTANCE = NativePRNG.initIO();

    private static RandomIO initIO() {
        return AccessController.doPrivileged(new PrivilegedAction<RandomIO>(){

            @Override
            public RandomIO run() {
                File file = new File(NativePRNG.NAME_RANDOM);
                if (!file.exists()) {
                    return null;
                }
                File file2 = new File(NativePRNG.NAME_URANDOM);
                if (!file2.exists()) {
                    return null;
                }
                try {
                    return new RandomIO(file, file2);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    static boolean isAvailable() {
        return INSTANCE != null;
    }

    public NativePRNG() {
        if (INSTANCE == null) {
            throw new AssertionError((Object)"NativePRNG not available");
        }
    }

    @Override
    protected void engineSetSeed(byte[] byArray) {
        NativePRNG.INSTANCE.implSetSeed(byArray);
    }

    @Override
    protected void engineNextBytes(byte[] byArray) {
        NativePRNG.INSTANCE.implNextBytes(byArray);
    }

    @Override
    protected byte[] engineGenerateSeed(int n) {
        return NativePRNG.INSTANCE.implGenerateSeed(n);
    }

    private static class RandomIO {
        private static final long MAX_BUFFER_TIME = 100L;
        private static final int BUFFER_SIZE = 32;
        private final InputStream randomIn;
        private final InputStream urandomIn;
        private OutputStream randomOut;
        private boolean randomOutInitialized;
        private volatile SecureRandom mixRandom;
        private final byte[] urandomBuffer;
        private int buffered;
        private long lastRead;
        private final Object LOCK_GET_BYTES = new Object();
        private final Object LOCK_GET_SEED = new Object();
        private final Object LOCK_SET_SEED = new Object();

        private RandomIO(File file, File file2) throws IOException {
            this.randomIn = new FileInputStream(file);
            this.urandomIn = new FileInputStream(file2);
            this.urandomBuffer = new byte[32];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SecureRandom getMixRandom() {
            SecureRandom secureRandom = this.mixRandom;
            if (secureRandom == null) {
                Object object = this.LOCK_GET_BYTES;
                synchronized (object) {
                    secureRandom = this.mixRandom;
                    if (secureRandom == null) {
                        secureRandom = new SecureRandom();
                        try {
                            byte[] byArray = new byte[20];
                            RandomIO.readFully(this.urandomIn, byArray);
                            secureRandom.engineSetSeed(byArray);
                        }
                        catch (IOException iOException) {
                            throw new ProviderException("init failed", iOException);
                        }
                        this.mixRandom = secureRandom;
                    }
                }
            }
            return secureRandom;
        }

        private static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
            int n;
            int n2;
            int n3 = 0;
            for (n = byArray.length; n > 0; n -= n2) {
                n2 = inputStream.read(byArray, n3, n);
                if (n2 <= 0) {
                    throw new EOFException("/dev/[u]random closed?");
                }
                n3 += n2;
            }
            if (n > 0) {
                throw new IOException("Could not read from /dev/[u]random");
            }
        }

        private byte[] implGenerateSeed(int n) {
            Object object = this.LOCK_GET_SEED;
            synchronized (object) {
                try {
                    byte[] byArray = new byte[n];
                    RandomIO.readFully(this.randomIn, byArray);
                    return byArray;
                }
                catch (IOException iOException) {
                    throw new ProviderException("generateSeed() failed", iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void implSetSeed(byte[] byArray) {
            Object object = this.LOCK_SET_SEED;
            synchronized (object) {
                if (!this.randomOutInitialized) {
                    this.randomOutInitialized = true;
                    this.randomOut = AccessController.doPrivileged(new PrivilegedAction<OutputStream>(){

                        @Override
                        public OutputStream run() {
                            try {
                                return new FileOutputStream(NativePRNG.NAME_RANDOM, true);
                            }
                            catch (Exception exception) {
                                return null;
                            }
                        }
                    });
                }
                if (this.randomOut != null) {
                    try {
                        this.randomOut.write(byArray);
                    }
                    catch (IOException iOException) {
                        throw new ProviderException("setSeed() failed", iOException);
                    }
                }
                this.getMixRandom().engineSetSeed(byArray);
            }
        }

        private void ensureBufferValid() throws IOException {
            long l = System.currentTimeMillis();
            if (this.buffered > 0 && l - this.lastRead < 100L) {
                return;
            }
            this.lastRead = l;
            RandomIO.readFully(this.urandomIn, this.urandomBuffer);
            this.buffered = this.urandomBuffer.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void implNextBytes(byte[] byArray) {
            Object object = this.LOCK_GET_BYTES;
            synchronized (object) {
                try {
                    this.getMixRandom().engineNextBytes(byArray);
                    int n = byArray.length;
                    int n2 = 0;
                    while (n > 0) {
                        this.ensureBufferValid();
                        int n3 = this.urandomBuffer.length - this.buffered;
                        while (n > 0 && this.buffered > 0) {
                            int n4 = n2++;
                            byArray[n4] = (byte)(byArray[n4] ^ this.urandomBuffer[n3++]);
                            --n;
                            --this.buffered;
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new ProviderException("nextBytes() failed", iOException);
                }
            }
        }
    }
}

