/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Iterator;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.ServerHandshaker;

final class SSLServerSocketImpl
extends SSLServerSocket {
    private SSLContextImpl sslContext;
    private byte doClientAuth = 0;
    private boolean useServerMode = true;
    private boolean enableSessionCreation = true;
    private CipherSuiteList enabledCipherSuites = null;
    private ProtocolList enabledProtocols = null;
    private boolean checkedEnabled = false;

    SSLServerSocketImpl(int n, int n2, SSLContextImpl sSLContextImpl) throws IOException, SSLException {
        super(n, n2);
        this.initServer(sSLContextImpl);
    }

    SSLServerSocketImpl(int n, int n2, InetAddress inetAddress, SSLContextImpl sSLContextImpl) throws IOException {
        super(n, n2, inetAddress);
        this.initServer(sSLContextImpl);
    }

    SSLServerSocketImpl(SSLContextImpl sSLContextImpl) throws IOException {
        this.initServer(sSLContextImpl);
    }

    private void initServer(SSLContextImpl sSLContextImpl) throws SSLException {
        if (sSLContextImpl == null) {
            throw new SSLException("No Authentication context given");
        }
        this.sslContext = sSLContextImpl;
        this.enabledCipherSuites = CipherSuiteList.getDefault();
        this.enabledProtocols = ProtocolList.getDefault();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        CipherSuiteList.clearAvailableCache();
        return CipherSuiteList.getSupported().toStringArray();
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites.toStringArray();
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = new CipherSuiteList(stringArray);
        this.checkedEnabled = false;
    }

    @Override
    public String[] getSupportedProtocols() {
        return ProtocolList.getSupported().toStringArray();
    }

    @Override
    public synchronized void setEnabledProtocols(String[] stringArray) {
        this.enabledProtocols = new ProtocolList(stringArray);
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.enabledProtocols.toStringArray();
    }

    @Override
    public void setNeedClientAuth(boolean bl) {
        this.doClientAuth = (byte)(bl ? 2 : 0);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.doClientAuth == 2;
    }

    @Override
    public void setWantClientAuth(boolean bl) {
        this.doClientAuth = bl ? (byte)1 : 0;
    }

    @Override
    public boolean getWantClientAuth() {
        return this.doClientAuth == 1;
    }

    @Override
    public void setUseClientMode(boolean bl) {
        this.useServerMode = !bl;
    }

    @Override
    public boolean getUseClientMode() {
        return !this.useServerMode;
    }

    @Override
    public void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public Socket accept() throws IOException {
        this.checkEnabledSuites();
        SSLSocketImpl sSLSocketImpl = new SSLSocketImpl(this.sslContext, this.useServerMode, this.enabledCipherSuites, this.doClientAuth, this.enableSessionCreation, this.enabledProtocols);
        this.implAccept(sSLSocketImpl);
        sSLSocketImpl.doneConnect();
        return sSLSocketImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEnabledSuites() throws IOException {
        SSLServerSocketImpl sSLServerSocketImpl = this;
        synchronized (sSLServerSocketImpl) {
            if (this.checkedEnabled) {
                return;
            }
            if (!this.useServerMode) {
                return;
            }
            SSLSocketImpl sSLSocketImpl = new SSLSocketImpl(this.sslContext, this.useServerMode, this.enabledCipherSuites, this.doClientAuth, this.enableSessionCreation, this.enabledProtocols);
            try {
                ServerHandshaker serverHandshaker = sSLSocketImpl.getServerHandshaker();
                Iterator<CipherSuite> iterator = this.enabledCipherSuites.iterator();
                while (true) {
                    if (iterator.hasNext()) {
                        CipherSuite cipherSuite = iterator.next();
                        if (!serverHandshaker.trySetCipherSuite(cipherSuite)) continue;
                        this.checkedEnabled = true;
                        return;
                        continue;
                    }
                    break;
                }
            }
            finally {
                sSLSocketImpl.closeSocket();
            }
            throw new SSLException("No available certificate or key corresponds to the SSL cipher suites which are enabled.");
        }
    }

    @Override
    public String toString() {
        return "[SSL: " + super.toString() + "]";
    }
}

