/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mac;

import gnu.java.security.hash.IMessageDigest;
import gnu.javax.crypto.mac.IMac;
import java.security.InvalidKeyException;
import java.util.Map;

public abstract class BaseMac
implements IMac {
    protected String name;
    protected IMessageDigest underlyingHash;
    protected int truncatedSize;

    public String name() {
        return this.name;
    }

    public int macSize() {
        return this.truncatedSize;
    }

    public void update(byte by) {
        this.underlyingHash.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.underlyingHash.update(byArray, n, n2);
    }

    public void reset() {
        this.underlyingHash.reset();
    }

    public Object clone() throws CloneNotSupportedException {
        BaseMac baseMac = (BaseMac)super.clone();
        if (this.underlyingHash != null) {
            baseMac.underlyingHash = (IMessageDigest)this.underlyingHash.clone();
        }
        return baseMac;
    }

    public abstract void init(Map var1) throws InvalidKeyException, IllegalStateException;

    public abstract byte[] digest();

    public abstract boolean selfTest();

    protected BaseMac(String string) {
        this.name = string;
    }

    protected BaseMac(String string, IMessageDigest iMessageDigest) {
        this(string);
        if (iMessageDigest != null) {
            this.truncatedSize = iMessageDigest.hashSize();
        }
        this.underlyingHash = iMessageDigest;
    }
}

