/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import gnu.xml.stream.AttributeImpl;
import gnu.xml.stream.CharactersImpl;
import gnu.xml.stream.CommentImpl;
import gnu.xml.stream.DTDImpl;
import gnu.xml.stream.EndDocumentImpl;
import gnu.xml.stream.EndElementImpl;
import gnu.xml.stream.EntityReferenceImpl;
import gnu.xml.stream.NamespaceImpl;
import gnu.xml.stream.ProcessingInstructionImpl;
import gnu.xml.stream.StartDocumentImpl;
import gnu.xml.stream.StartElementImpl;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.stream.util.XMLEventConsumer;

public class XMLEventAllocatorImpl
implements XMLEventAllocator {
    protected Map entityDeclarations = new HashMap();

    public XMLEvent allocate(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        int n = xMLStreamReader.getEventType();
        Location location = xMLStreamReader.getLocation();
        switch (n) {
            case 12: {
                String string = xMLStreamReader.getText();
                boolean bl = this.isWhitespace(string);
                boolean bl2 = false;
                return new CharactersImpl(location, string, bl, true, bl2);
            }
            case 4: {
                String string = xMLStreamReader.getText();
                boolean bl = false;
                boolean bl3 = false;
                return new CharactersImpl(location, string, bl, false, bl3);
            }
            case 5: {
                String string = xMLStreamReader.getText();
                return new CommentImpl(location, string);
            }
            case 11: {
                String string = xMLStreamReader.getText();
                LinkedList linkedList = new LinkedList();
                LinkedList linkedList2 = new LinkedList();
                return new DTDImpl(location, string, null, linkedList, linkedList2);
            }
            case 8: {
                return new EndDocumentImpl(location);
            }
            case 2: {
                int n2 = xMLStreamReader.getNamespaceCount();
                LinkedList linkedList = new LinkedList();
                int n3 = 0;
                while (n3 < n2) {
                    linkedList.add(new NamespaceImpl(location, xMLStreamReader.getNamespacePrefix(n3), xMLStreamReader.getNamespaceURI(n3)));
                    ++n3;
                }
                return new EndElementImpl(location, xMLStreamReader.getName(), linkedList);
            }
            case 9: {
                String string = xMLStreamReader.getLocalName();
                EntityDeclaration entityDeclaration = (EntityDeclaration)this.entityDeclarations.get(string);
                return new EntityReferenceImpl(location, entityDeclaration, string);
            }
            case 3: {
                return new ProcessingInstructionImpl(location, xMLStreamReader.getPITarget(), xMLStreamReader.getPIData());
            }
            case 6: {
                String string = xMLStreamReader.getText();
                boolean bl = true;
                boolean bl4 = false;
                return new CharactersImpl(location, string, bl, false, bl4);
            }
            case 7: {
                String string;
                boolean bl;
                String string2 = location.getSystemId();
                String string3 = xMLStreamReader.getCharacterEncodingScheme();
                boolean bl5 = false;
                if (string3 != null) {
                    bl5 = bl = true;
                }
                if (string3 == null && (string3 = xMLStreamReader.getEncoding()) == null) {
                    string3 = "UTF-8";
                }
                if ((string = xMLStreamReader.getVersion()) == null) {
                    string = "1.0";
                }
                boolean bl6 = xMLStreamReader.isStandalone();
                boolean bl7 = xMLStreamReader.standaloneSet();
                return new StartDocumentImpl(location, string2, string3, string, bl6, bl7, bl);
            }
            case 1: {
                int n4 = xMLStreamReader.getNamespaceCount();
                LinkedList linkedList = new LinkedList();
                int n5 = 0;
                while (n5 < n4) {
                    linkedList.add(new NamespaceImpl(location, xMLStreamReader.getNamespacePrefix(n5), xMLStreamReader.getNamespaceURI(n5)));
                    ++n5;
                }
                n4 = xMLStreamReader.getAttributeCount();
                LinkedList linkedList3 = new LinkedList();
                int n6 = 0;
                while (n6 < n4) {
                    linkedList3.add(new AttributeImpl(location, xMLStreamReader.getAttributeName(n6), xMLStreamReader.getAttributeValue(n6), QName.valueOf(xMLStreamReader.getAttributeType(n6)), xMLStreamReader.isAttributeSpecified(n6)));
                    ++n6;
                }
                return new StartElementImpl(location, xMLStreamReader.getName(), linkedList3, linkedList, xMLStreamReader.getNamespaceContext());
            }
        }
        throw new XMLStreamException("Unknown event type: " + n);
    }

    public void allocate(XMLStreamReader xMLStreamReader, XMLEventConsumer xMLEventConsumer) throws XMLStreamException {
        xMLEventConsumer.add(this.allocate(xMLStreamReader));
    }

    public XMLEventAllocator newInstance() {
        return new XMLEventAllocatorImpl();
    }

    protected boolean isWhitespace(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected XMLEventAllocatorImpl() {
    }
}

