/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.BinaryAnalyser;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.openide.util.Exceptions;

public class JavaBinaryIndexer
extends BinaryIndexer {
    static final Logger LOG = Logger.getLogger(JavaBinaryIndexer.class.getName());

    protected void index(final Context context) {
        LOG.log(Level.FINE, "index({0})", context.getRootURI());
        try {
            final ClassIndexManager cim = ClassIndexManager.getDefault();
            cim.prepareWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public Void run() throws IOException, InterruptedException {
                    BinaryAnalyser ba;
                    CachingArchiveProvider.getDefault().clearArchive(context.getRootURI());
                    File cacheFolder = JavaIndex.getClassFolder(context.getRootURI());
                    FileObjects.deleteRecursively(cacheFolder);
                    ClassIndexImpl uq = cim.createUsagesQuery(context.getRootURI(), false);
                    if (uq == null) {
                        return null;
                    }
                    if (!context.isAllFilesIndexing() || (ba = uq.getBinaryAnalyser()) == null) return null;
                    BinaryAnalyser.Result finished = null;
                    try {
                        finished = ba.start(context);
                        while (finished == BinaryAnalyser.Result.CANCELED) {
                            finished = ba.resume();
                        }
                        if (finished != BinaryAnalyser.Result.FINISHED) return null;
                    }
                    catch (Throwable throwable) {
                        if (finished != BinaryAnalyser.Result.FINISHED) throw throwable;
                        BinaryAnalyser.Changes changes = ba.finish();
                        Map binDeps = IndexingController.getDefault().getBinaryRootDependencies();
                        Map srcDeps = IndexingController.getDefault().getRootDependencies();
                        ArrayList<ElementHandle<TypeElement>> changed = new ArrayList<ElementHandle<TypeElement>>(changes.changed.size() + changes.removed.size());
                        changed.addAll(changes.changed);
                        changed.addAll(changes.removed);
                        Map<URL, Set<URL>> toRebuild = JavaCustomIndexer.findDependent(context.getRootURI(), srcDeps, binDeps, changed, !changes.added.isEmpty(), false);
                        for (Map.Entry<URL, Set<URL>> entry : toRebuild.entrySet()) {
                            context.addSupplementaryFiles(entry.getKey(), (Collection)entry.getValue());
                        }
                        throw throwable;
                    }
                    BinaryAnalyser.Changes changes = ba.finish();
                    Map binDeps = IndexingController.getDefault().getBinaryRootDependencies();
                    Map srcDeps = IndexingController.getDefault().getRootDependencies();
                    ArrayList<ElementHandle<TypeElement>> changed = new ArrayList<ElementHandle<TypeElement>>(changes.changed.size() + changes.removed.size());
                    changed.addAll(changes.changed);
                    changed.addAll(changes.removed);
                    Map<URL, Set<URL>> toRebuild = JavaCustomIndexer.findDependent(context.getRootURI(), srcDeps, binDeps, changed, !changes.added.isEmpty(), false);
                    for (Map.Entry<URL, Set<URL>> entry : toRebuild.entrySet()) {
                        context.addSupplementaryFiles(entry.getKey(), (Collection)entry.getValue());
                    }
                    return null;
                }
            });
        }
        catch (IllegalArgumentException iae) {
            Exceptions.printStackTrace((Throwable)iae);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        catch (InterruptedException ie) {
            Exceptions.printStackTrace((Throwable)ie);
        }
    }

    public static class Factory
    extends BinaryIndexerFactory {
        public BinaryIndexer createIndexer() {
            return new JavaBinaryIndexer();
        }

        public String getIndexerName() {
            return "java";
        }

        public int getIndexVersion() {
            return 14;
        }

        public void rootsRemoved(final Iterable<? extends URL> removedRoots) {
            assert (removedRoots != null);
            final ClassIndexManager cim = ClassIndexManager.getDefault();
            try {
                cim.prepareWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, InterruptedException {
                        for (URL removedRoot : removedRoots) {
                            cim.removeRoot(removedRoot);
                        }
                        return null;
                    }
                });
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            catch (InterruptedException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }

        public boolean scanStarted(final Context context) {
            try {
                return ClassIndexManager.getDefault().prepareWriteLock(new ClassIndexManager.ExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws IOException, InterruptedException {
                        return ClassIndexManager.getDefault().takeWriteLock(new ClassIndexManager.ExceptionAction<Boolean>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Boolean run() throws IOException, InterruptedException {
                                ClassIndexImpl uq = ClassIndexManager.getDefault().createUsagesQuery(context.getRootURI(), true);
                                if (uq == null) {
                                    return true;
                                }
                                if (uq.getState() != ClassIndexImpl.State.NEW) {
                                    return true;
                                }
                                try {
                                    Boolean bl = uq.getBinaryAnalyser().isValid();
                                    return bl;
                                }
                                finally {
                                    uq.setState(ClassIndexImpl.State.INITIALIZED);
                                }
                            }
                        });
                    }
                });
            }
            catch (IOException ioe) {
                JavaIndex.LOG.log(Level.WARNING, "Exception while checking cache validity for root: " + context.getRootURI(), ioe);
                return false;
            }
            catch (InterruptedException ie) {
                JavaIndex.LOG.log(Level.WARNING, "Exception while checking cache validity for root: " + context.getRootURI(), ie);
                return false;
            }
        }
    }
}

