/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.ruby.rubyproject.RubyActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class RubyFileLocator
implements LineConvertors.FileLocator {
    protected Lookup context;
    protected Project project;

    public RubyFileLocator(Lookup context, Project project) {
        assert (project != null);
        this.context = context;
        this.project = project;
    }

    public FileObject find(String path) {
        SourceGroup[] generalGroups;
        File file = new File(path);
        if (file.isAbsolute() && file.isFile()) {
            return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        }
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
        if (sources == null) {
            return null;
        }
        SourceGroup[] rubyGroups = sources.getSourceGroups("ruby");
        if (rubyGroups != null) {
            for (SourceGroup group : rubyGroups) {
                roots.add(group.getRootFolder());
            }
        }
        if ((generalGroups = sources.getSourceGroups("generic")) != null) {
            for (SourceGroup group : generalGroups) {
                roots.add(group.getRootFolder());
            }
        }
        for (FileObject root : roots) {
            File relToPrjDir = new File(FileUtil.toFile((FileObject)root), path);
            if (!relToPrjDir.isFile()) continue;
            try {
                relToPrjDir = relToPrjDir.getCanonicalFile();
                return FileUtil.toFileObject((File)relToPrjDir);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        FileObject[] fos = this.findSources(roots);
        String fileName = new File(path).getName();
        if (fos != null) {
            for (FileObject fo : fos) {
                if (!fo.getNameExt().equals(fileName)) continue;
                return fo;
            }
        }
        for (FileObject root : roots) {
            FileObject fo = this.findFile(root, fileName);
            if (fo == null) continue;
            return fo;
        }
        return null;
    }

    private FileObject findFile(FileObject fo, String fileName) {
        if (fileName.equals(fo.getNameExt())) {
            return fo;
        }
        for (FileObject child : fo.getChildren()) {
            FileObject found = this.findFile(child, fileName);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    protected Lookup getContext() {
        if (this.context == null) {
            this.context = this.project.getLookup();
        }
        return this.context;
    }

    protected FileObject[] findSources(List<FileObject> roots) {
        for (FileObject root : roots) {
            FileObject[] files = RubyActionProvider.findSelectedFiles(this.getContext(), root, "text/x-ruby", true);
            if (files == null) continue;
            return files;
        }
        return null;
    }
}

