/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.cap.TypeDescriptorEntry;
import java.util.Vector;

public class SignaturePool {
    JCPackage parentPackage;
    public Vector<TypeDescriptorEntry> methodSignaturePool;
    public int relocAddress;

    public SignaturePool(JCPackage jCPackage) {
        this.parentPackage = jCPackage;
    }

    public short addMethodToSignaturePool(String string, JCClass jCClass) {
        TypeDescriptorEntry typeDescriptorEntry = new TypeDescriptorEntry(string, jCClass);
        int n = this.methodSignaturePool.indexOf(typeDescriptorEntry);
        if (n == -1) {
            this.methodSignaturePool.addElement(typeDescriptorEntry);
        }
        return this.getMethodSignatureOffset(typeDescriptorEntry);
    }

    public short getMethodSignatureOffset(TypeDescriptorEntry typeDescriptorEntry) {
        short s = 0;
        int n = this.methodSignaturePool.indexOf(typeDescriptorEntry);
        for (int i = 0; i < n; ++i) {
            typeDescriptorEntry = this.methodSignaturePool.elementAt(i);
            s = (short)(s + (short)typeDescriptorEntry.getData().length);
        }
        return s;
    }

    public short getMethodSignatureOffset(JCMethod jCMethod) {
        assert (jCMethod != null) : "method != null";
        TypeDescriptorEntry typeDescriptorEntry = new TypeDescriptorEntry(jCMethod, 0);
        return this.getMethodSignatureOffset(typeDescriptorEntry);
    }

    public void relocate(int n) {
        this.relocAddress = n;
    }

    public int getAddressForOffset(int n) {
        return this.relocAddress + n;
    }

    public int getSize() {
        int n = 0;
        byte[] byArray = null;
        for (int i = 0; i < this.methodSignaturePool.size(); ++i) {
            TypeDescriptorEntry typeDescriptorEntry = this.methodSignaturePool.elementAt(i);
            byArray = typeDescriptorEntry.getData();
            n += byArray.length;
        }
        return n;
    }
}

