/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.ClassDumpInstance;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HeapProgress;
import org.netbeans.lib.profiler.heap.HprofFieldObjectValue;
import org.netbeans.lib.profiler.heap.HprofGCRoot;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.HprofInstanceObjectValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LongBuffer;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;

class NearestGCRoot {
    private static final int BUFFER_SIZE = 8192;
    private static final String[] REF_CLASSES = new String[]{"java.lang.ref.WeakReference", "java.lang.ref.SoftReference", "java.lang.ref.FinalReference", "java.lang.ref.PhantomReference"};
    private static final String JAVA_LANG_REF_REFERENCE = "java.lang.ref.Reference";
    private static final String REFERENT_FILED_NAME = "referent";
    private Field referentFiled;
    private HprofHeap heap;
    private LongBuffer readBuffer;
    private LongBuffer writeBuffer;
    private LongBuffer leaves;
    private LongBuffer multipleParents;
    private Set referenceClasses;
    private boolean gcRootsComputed;
    private long allInstances;
    private long processedInstances;

    NearestGCRoot(HprofHeap h) {
        this.heap = h;
    }

    Instance getNearestGCRootPointer(Instance instance) {
        if (this.heap.getGCRoot(instance) != null) {
            return instance;
        }
        this.computeGCRoots();
        long nextGCPathId = this.heap.idToOffsetMap.get(instance.getInstanceId()).getNearestGCRootPointer();
        return this.heap.getInstanceByID(nextGCPathId);
    }

    private boolean isSpecialReference(FieldValue value, Instance instance) {
        Field f = value.getField();
        return f.equals(this.referentFiled) && this.referenceClasses.contains(instance.getJavaClass());
    }

    private synchronized void computeGCRoots() {
        if (this.gcRootsComputed) {
            return;
        }
        this.referenceClasses = new HashSet();
        for (int i = 0; i < REF_CLASSES.length; ++i) {
            JavaClass ref = this.heap.getJavaClassByName(REF_CLASSES[i]);
            this.referenceClasses.add(ref);
            this.referenceClasses.addAll(ref.getSubClasses());
        }
        this.referentFiled = this.computeReferentFiled();
        this.heap.computeReferences();
        this.allInstances = this.heap.getSummary().getTotalLiveInstances();
        try {
            this.createBuffers();
            this.fillZeroLevel();
            do {
                this.switchBuffers();
                this.computeOneLevel();
            } while (this.hasMoreLevels());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.deleteBuffers();
        this.heap.idToOffsetMap.flush();
        HeapProgress.progressFinish();
        this.gcRootsComputed = true;
    }

    private void computeOneLevel() throws IOException {
        int idSize = this.heap.dumpBuffer.getIDSize();
        while (true) {
            List fieldValues;
            long instanceId = this.readLong();
            boolean hasValues = false;
            if (instanceId == 0L) break;
            HeapProgress.progress(this.processedInstances++, this.allInstances);
            Instance instance = this.heap.getInstanceByID(instanceId);
            if (instance instanceof ObjectArrayInstance) {
                ObjectArrayDump array = (ObjectArrayDump)instance;
                int size = array.getLength();
                long offset = array.getOffset();
                for (int i = 0; i < size; ++i) {
                    long referenceId = this.heap.dumpBuffer.getID(offset + (long)(i * idSize));
                    if (!this.writeConnection(instanceId, referenceId)) continue;
                    hasValues = true;
                }
                if (hasValues) continue;
                this.writeLeaf(instanceId, instance.getSize());
                continue;
            }
            if (instance instanceof PrimitiveArrayInstance) {
                this.writeLeaf(instanceId, instance.getSize());
                continue;
            }
            if (instance instanceof ClassDumpInstance) {
                ClassDump javaClass = ((ClassDumpInstance)instance).classDump;
                fieldValues = javaClass.getStaticFieldValues();
            } else if (instance instanceof InstanceDump) {
                fieldValues = instance.getFieldValues();
            } else {
                if (instance == null) {
                    System.err.println("HeapWalker Warning - null instance for " + instanceId);
                    continue;
                }
                throw new IllegalArgumentException("Illegal type " + instance.getClass());
            }
            for (FieldValue val : fieldValues) {
                long refInstanceId;
                if (!(val instanceof ObjectFieldValue) || this.isSpecialReference(val, instance) || !this.writeConnection(instanceId, refInstanceId = val instanceof HprofFieldObjectValue ? ((HprofFieldObjectValue)val).getInstanceID() : ((HprofInstanceObjectValue)val).getInstanceId())) continue;
                hasValues = true;
            }
            if (hasValues) continue;
            this.writeLeaf(instanceId, instance.getSize());
        }
    }

    private Field computeReferentFiled() {
        JavaClass reference = this.heap.getJavaClassByName(JAVA_LANG_REF_REFERENCE);
        for (Field f : reference.getFields()) {
            if (!f.getName().equals(REFERENT_FILED_NAME)) continue;
            return f;
        }
        throw new IllegalArgumentException("reference field not found in " + reference.getName());
    }

    private void createBuffers() {
        this.readBuffer = new LongBuffer(8192);
        this.writeBuffer = new LongBuffer(8192);
        this.leaves = new LongBuffer(8192);
        this.multipleParents = new LongBuffer(8192);
    }

    private void deleteBuffers() {
        this.readBuffer.delete();
        this.writeBuffer.delete();
    }

    private void fillZeroLevel() throws IOException {
        for (HprofGCRoot root : this.heap.getGCRoots()) {
            this.writeLong(root.getInstanceId());
        }
    }

    private boolean hasMoreLevels() {
        return this.writeBuffer.hasData();
    }

    private long readLong() throws IOException {
        return this.readBuffer.readLong();
    }

    private void switchBuffers() {
        LongBuffer b = this.readBuffer;
        this.readBuffer = this.writeBuffer;
        this.writeBuffer = b;
        this.readBuffer.startReading();
        this.writeBuffer.reset();
    }

    private boolean writeConnection(long instanceId, long refInstanceId) throws IOException {
        if (refInstanceId != 0L) {
            LongMap.Entry entry = this.heap.idToOffsetMap.get(refInstanceId);
            if (entry != null && entry.getNearestGCRootPointer() == 0L && this.heap.getGCRoot(refInstanceId) == null) {
                this.writeLong(refInstanceId);
                entry.setNearestGCRootPointer(instanceId);
                if (!entry.hasOnlyOneReference()) {
                    this.multipleParents.writeLong(refInstanceId);
                }
            }
            return entry != null;
        }
        return false;
    }

    private void writeLong(long instanceId) throws IOException {
        this.writeBuffer.writeLong(instanceId);
    }

    private void writeLeaf(long instanceId, int size) throws IOException {
        LongMap.Entry gcRootPointerEntry;
        long gcRootPointer;
        LongMap.Entry entry = this.heap.idToOffsetMap.get(instanceId);
        entry.setTreeObj();
        entry.setRetainedSize(size);
        if (entry.hasOnlyOneReference() && (gcRootPointer = entry.getNearestGCRootPointer()) != 0L && (gcRootPointerEntry = this.heap.idToOffsetMap.get(gcRootPointer)).getRetainedSize() == 0) {
            gcRootPointerEntry.setRetainedSize(-1);
            this.leaves.writeLong(gcRootPointer);
        }
    }

    LongBuffer getLeaves() {
        this.computeGCRoots();
        return this.leaves;
    }

    LongBuffer getMultipleParents() {
        this.computeGCRoots();
        return this.multipleParents;
    }
}

