/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;

public class SmartChangeEvent {
    protected Map<CsmProject, Storage> changedProjects = new HashMap<CsmProject, Storage>();
    private int count = 1;

    public SmartChangeEvent(CsmChangeEvent e) {
        this.doAdd(e);
    }

    public boolean addChangeEvent(CsmChangeEvent e) {
        if (e.getRemovedDeclarations().size() == 0) {
            this.doAdd(e);
            ++this.count;
            return true;
        }
        return false;
    }

    public boolean addChangeEvent(SmartChangeEvent e) {
        for (Storage storage : this.getChangedProjects().values()) {
            if (storage.getRemovedDeclarations().size() <= 0 && storage.getRemovedNamespaces().size() <= 0) continue;
            return false;
        }
        this.doAdd(e);
        ++this.count;
        return true;
    }

    int getCount() {
        return this.count;
    }

    private void doAdd(SmartChangeEvent e) {
        for (Map.Entry<CsmProject, Storage> entry : e.getChangedProjects().entrySet()) {
            CsmProject project = entry.getKey();
            Storage storage = this.changedProjects.get(project);
            if (storage == null) {
                this.changedProjects.put(project, entry.getValue());
                continue;
            }
            storage.getNewNamespaces().addAll(entry.getValue().getNewNamespaces());
            storage.getRemovedNamespaces().addAll(entry.getValue().getRemovedNamespaces());
            storage.getNewDeclarations().addAll(entry.getValue().getNewDeclarations());
            storage.getRemovedDeclarations().addAll(entry.getValue().getRemovedDeclarations());
            storage.getChangedDeclarations().putAll(entry.getValue().getChangedDeclarations());
        }
    }

    private void doAdd(CsmChangeEvent e) {
        Storage storage;
        for (CsmNamespace csmNamespace : e.getNewNamespaces()) {
            storage = this.getStorage(csmNamespace);
            if (storage == null) continue;
            storage.addNewNamespaces(csmNamespace);
        }
        for (CsmNamespace csmNamespace : e.getRemovedNamespaces()) {
            storage = this.getStorage(csmNamespace);
            if (storage == null) continue;
            storage.addRemovedNamespaces(csmNamespace);
        }
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : e.getNewDeclarations()) {
            storage = this.getStorage(csmOffsetableDeclaration);
            if (storage == null) continue;
            storage.addNewDeclaration(csmOffsetableDeclaration);
        }
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : e.getRemovedDeclarations()) {
            storage = this.getStorage(csmOffsetableDeclaration);
            if (storage == null) continue;
            storage.addRemovedDeclarations(csmOffsetableDeclaration);
        }
        for (Map.Entry entry : e.getChangedDeclarations().entrySet()) {
            storage = this.getStorage((CsmOffsetableDeclaration)entry.getValue());
            if (storage == null) continue;
            storage.addChangedDeclarations((CsmOffsetableDeclaration)entry.getKey(), (CsmOffsetableDeclaration)entry.getValue());
        }
    }

    private Storage getStorage(CsmNamespace ns) {
        CsmProject project = ns.getProject();
        if (project != null && project.isValid()) {
            Storage storage = this.changedProjects.get(project);
            if (storage == null) {
                storage = new Storage(project);
                this.changedProjects.put(project, storage);
            }
            return storage;
        }
        return null;
    }

    private Storage getStorage(CsmOffsetableDeclaration decl) {
        CsmProject project = SmartChangeEvent.findProject(decl);
        if (project != null && project.isValid()) {
            Storage storage = this.changedProjects.get(project);
            if (storage == null) {
                storage = new Storage(project);
                this.changedProjects.put(project, storage);
            }
            return storage;
        }
        return null;
    }

    private static CsmProject findProject(CsmOffsetableDeclaration decl) {
        CsmFile file = decl.getContainingFile();
        if (file != null) {
            if (file.isValid()) {
                return file.getProject();
            }
            return null;
        }
        System.err.println("Cannot fing project for declaration " + decl.getUniqueName());
        return null;
    }

    public Map<CsmProject, Storage> getChangedProjects() {
        return this.changedProjects;
    }

    public static class Storage {
        private CsmProject changedProject;
        private Set<CsmNamespace> newNamespaces = new HashSet<CsmNamespace>();
        private Set<CsmNamespace> removedNamespaces = new HashSet<CsmNamespace>();
        private Set<CsmOffsetableDeclaration> newDeclarations = new HashSet<CsmOffsetableDeclaration>();
        private Set<CsmOffsetableDeclaration> removedDeclarations = new HashSet<CsmOffsetableDeclaration>();
        private Map<CsmOffsetableDeclaration, CsmOffsetableDeclaration> changedDeclarations = new HashMap<CsmOffsetableDeclaration, CsmOffsetableDeclaration>();

        public Storage(CsmProject project) {
            this.changedProject = project;
        }

        public Collection<CsmOffsetableDeclaration> getNewDeclarations() {
            return this.newDeclarations;
        }

        private void addNewDeclaration(CsmOffsetableDeclaration declaration) {
            this.newDeclarations.add(declaration);
        }

        public Collection<CsmOffsetableDeclaration> getRemovedDeclarations() {
            return this.removedDeclarations;
        }

        private void addRemovedDeclarations(CsmOffsetableDeclaration declaration) {
            this.removedDeclarations.add(declaration);
        }

        public Map<CsmOffsetableDeclaration, CsmOffsetableDeclaration> getChangedDeclarations() {
            return this.changedDeclarations;
        }

        private void addChangedDeclarations(CsmOffsetableDeclaration oldDecl, CsmOffsetableDeclaration newDecl) {
            this.changedDeclarations.put(oldDecl, newDecl);
        }

        public CsmProject getProject() {
            return this.changedProject;
        }

        public Collection<CsmNamespace> getNewNamespaces() {
            return this.newNamespaces;
        }

        private void addNewNamespaces(CsmNamespace ns) {
            this.newNamespaces.add(ns);
        }

        public Collection<CsmNamespace> getRemovedNamespaces() {
            return this.removedNamespaces;
        }

        private void addRemovedNamespaces(CsmNamespace ns) {
            this.removedNamespaces.add(ns);
        }
    }
}

