/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.jaxws.impl;

import java.net.URL;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

public abstract class AbstractJaxWsStack
implements WSStackImplementation<JaxWs> {
    private JaxWs jaxWs = new JaxWs(this.getUriDescriptor());

    protected AbstractJaxWsStack() {
    }

    public JaxWs get() {
        return this.jaxWs;
    }

    public WSTool getWSTool(WSStack.Tool toolId) {
        if (toolId == JaxWs.Tool.WSIMPORT) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSIMPORT));
        }
        if (toolId == JaxWs.Tool.WSGEN) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSGEN));
        }
        return null;
    }

    public JaxWs.UriDescriptor getUriDescriptor() {
        return new JaxWs.UriDescriptor(){

            @Override
            public String getServiceUri(String applicationRoot, String serviceName, String portName, boolean isEjb) {
                return applicationRoot + "/" + serviceName;
            }

            @Override
            public String getDescriptorUri(String applicationRoot, String serviceName, String portName, boolean isEjb) {
                return this.getServiceUri(applicationRoot, serviceName, portName, isEjb) + "?wsdl";
            }

            @Override
            public String getTesterPageUri(String applicationRoot, String serviceName, String portName, boolean isEjb) {
                return applicationRoot + "/" + serviceName;
            }
        };
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        return feature == JaxWs.Feature.TESTER_PAGE;
    }

    private class JaxWsTool
    implements WSToolImplementation {
        JaxWs.Tool tool;

        JaxWsTool(JaxWs.Tool tool) {
            this.tool = tool;
        }

        public String getName() {
            return this.tool.getName();
        }

        public URL[] getLibraries() {
            return new URL[0];
        }
    }
}

