/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Future;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.tools.Diagnostic;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.modules.java.preprocessorbridge.spi.WrapperFactory;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class WatchPanel {
    private JPanel panel;
    private JEditorPane editorPane;
    private String expression;

    public WatchPanel(String string) {
        this.expression = string;
    }

    public static void setupContext(final JEditorPane jEditorPane, final ActionListener actionListener) {
        Context context;
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (EventQueue.isDispatchThread() && debuggerEngine != null) {
            context = (RequestProcessor)debuggerEngine.lookupFirst(null, RequestProcessor.class);
            if (context != null) {
                final DebuggerEngine debuggerEngine2 = debuggerEngine;
                context.post(new Runnable(){

                    @Override
                    public void run() {
                        Context context = WatchPanel.retrieveContext(debuggerEngine2);
                        if (context != null) {
                            WatchPanel.setupContext(jEditorPane, context.url, context.line, context.debugger);
                            if (actionListener != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        actionListener.actionPerformed(null);
                                    }
                                });
                            }
                        }
                    }
                });
                Context context2 = WatchPanel.retrieveContext(null);
                if (context2 != null) {
                    WatchPanel.setupContext(jEditorPane, context2.url, context2.line, context2.debugger);
                } else {
                    WatchPanel.setupUI(jEditorPane);
                }
                return;
            }
            debuggerEngine = null;
        }
        if ((context = WatchPanel.retrieveContext(debuggerEngine)) != null) {
            WatchPanel.setupContext(jEditorPane, context.url, context.line, context.debugger);
        } else {
            WatchPanel.setupUI(jEditorPane);
        }
        if (actionListener != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    actionListener.actionPerformed(null);
                }
            });
        }
    }

    private static Context retrieveContext(DebuggerEngine debuggerEngine) {
        CallStackFrame callStackFrame = null;
        JPDADebugger jPDADebugger = null;
        if (debuggerEngine != null && (jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class)) != null) {
            callStackFrame = jPDADebugger.getCurrentCallStackFrame();
        }
        if (callStackFrame != null) {
            Session session = (Session)debuggerEngine.lookupFirst(null, Session.class);
            String string = session.getCurrentLanguage();
            SourcePath sourcePath = (SourcePath)debuggerEngine.lookupFirst(null, SourcePath.class);
            Context context = new Context();
            context.url = sourcePath.getURL(callStackFrame, string);
            context.line = callStackFrame.getLineNumber(string);
            if (context.line == -1) {
                context.line = 1;
            }
            context.debugger = jPDADebugger;
            return context;
        }
        EditorContext editorContext = EditorContextBridge.getContext();
        String string = editorContext.getCurrentURL();
        if (string != null && string.length() > 0) {
            Context context = new Context();
            context.url = string;
            context.line = editorContext.getCurrentLineNumber();
            if (context.line == -1) {
                context.line = 1;
            }
            context.debugger = jPDADebugger;
            return context;
        }
        string = EditorContextDispatcher.getDefault().getMostRecentURLAsString();
        if (string != null && string.length() > 0) {
            Context context = new Context();
            context.url = string;
            context.line = EditorContextDispatcher.getDefault().getMostRecentLineNumber();
            if (context.line == -1) {
                context.line = 1;
            }
            context.debugger = jPDADebugger;
            return context;
        }
        return null;
    }

    public static void setupContext(JEditorPane jEditorPane, String string, int n) {
        WatchPanel.setupContext(jEditorPane, string, n, null);
    }

    public static void setupContext(final JEditorPane jEditorPane, String string, int n, final JPDADebugger jPDADebugger) {
        StyledDocument styledDocument;
        Object object;
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
            if (fileObject == null) {
                return;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                object = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (object == null) {
                    return;
                }
                try {
                    styledDocument = object.openDocument();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    return;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        try {
            final int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n - 1));
            object = new Runnable(){

                @Override
                public void run() {
                    String string = jEditorPane.getText();
                    DialogBinding.bindComponentToDocument((Document)styledDocument, (int)n2, (int)0, (JTextComponent)jEditorPane);
                    Document document = jEditorPane.getDocument();
                    document.putProperty("org.netbeans.modules.editor.java.JavaCompletionProvider.skipAccessibilityCheck", "true");
                    document.putProperty(WrapperFactory.class, jPDADebugger != null ? new MyWrapperFactory(jPDADebugger, fileObject, styledDocument) : null);
                    jEditorPane.setText(string);
                }
            };
            if (EventQueue.isDispatchThread()) {
                object.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait((Runnable)object);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Exceptions.printStackTrace((Throwable)invocationTargetException);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ErrorManager.getDefault().notify(1, (Throwable)indexOutOfBoundsException);
        }
        WatchPanel.setupUI(jEditorPane);
    }

    private static void setupUI(final JEditorPane jEditorPane) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jEditorPane);
                if (editorUI == null) {
                    return;
                }
                jEditorPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
                try {
                    Field field = EditorUI.class.getDeclaredField("textLimitLineVisible");
                    field.setAccessible(true);
                    field.set(editorUI, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jEditorPane.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public JComponent getPanel() {
        Object object;
        String string;
        Object object2;
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel();
        ResourceBundle resourceBundle = NbBundle.getBundle(WatchPanel.class);
        this.panel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_WatchPanel"));
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)resourceBundle.getString("CTL_Watch_Name"));
        if (this.expression != null && this.expression.trim().length() == 0 && (object2 = EditorContextDispatcher.getDefault().getMostRecentEditor()) != null && ((JTextComponent)object2).getDocument() instanceof StyledDocument && (string = WatchPanel.getSelectedIdentifier((StyledDocument)(object = (StyledDocument)((JTextComponent)object2).getDocument()), (JEditorPane)object2, ((JTextComponent)object2).getCaret().getDot())) != null) {
            this.expression = string;
        }
        this.editorPane = new JEditorPane();
        this.editorPane.setText(this.expression);
        object2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WatchPanel.this.editorPane.setText(WatchPanel.this.expression);
                WatchPanel.this.editorPane.selectAll();
            }
        };
        WatchPanel.setupContext(this.editorPane, (ActionListener)object2);
        object = WatchPanel.createScrollableLineEditor(this.editorPane);
        int n = ((JComponent)object).getPreferredSize().height;
        int n2 = Math.min(70 * this.editorPane.getFontMetrics(this.editorPane.getFont()).charWidth('a'), WindowManager.getDefault().getMainWindow().getSize().width);
        ((JComponent)object).setPreferredSize(new Dimension(n2, n));
        jLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.panel.add("North", jLabel);
        this.panel.add("Center", (Component)object);
        this.editorPane.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Watch_Name"));
        this.editorPane.setText(this.expression);
        this.editorPane.selectAll();
        jLabel.setLabelFor(this.editorPane);
        HelpCtx.setHelpIDString((JComponent)this.editorPane, (String)"debug.customize.watch");
        this.editorPane.requestFocus();
        return this.panel;
    }

    public String getExpression() {
        return this.editorPane.getText().trim();
    }

    public static JScrollPane createScrollableLineEditor(JEditorPane jEditorPane) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(9, 0);
        InputMap inputMap = jEditorPane.getInputMap();
        inputMap.put(keyStroke, "none");
        inputMap.put(keyStroke2, "none");
        inputMap.put(keyStroke3, "none");
        JScrollPane jScrollPane = new JScrollPane(21, 31);
        jEditorPane.setBorder(new CompoundBorder(jEditorPane.getBorder(), new EmptyBorder(0, 0, 0, 0)));
        JTextField jTextField = new JTextField("M");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(jTextField.getBackground());
        jScrollPane.setBorder(jTextField.getBorder());
        jScrollPane.setBackground(jTextField.getBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jEditorPane, gridBagConstraints);
        jScrollPane.setViewportView(jPanel);
        int n = jTextField.getPreferredSize().height;
        Dimension dimension = jScrollPane.getPreferredSize();
        if (dimension.height < n) {
            jScrollPane.setPreferredSize(jTextField.getPreferredSize());
        } else {
            jScrollPane.setPreferredSize(dimension);
        }
        jScrollPane.setMinimumSize(dimension);
        WatchPanel.setupUI(jEditorPane);
        Set<AWTKeyStroke> set = jTextField.getFocusTraversalKeys(0);
        jEditorPane.setFocusTraversalKeys(0, set);
        set = jTextField.getFocusTraversalKeys(1);
        jEditorPane.setFocusTraversalKeys(1, set);
        return jScrollPane;
    }

    private static String getSelectedIdentifier(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        String string = null;
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            string = jEditorPane.getSelectedText();
        }
        if (string != null) {
            return string;
        }
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        try {
            int n4;
            int n5;
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
            if (element == null) {
                return null;
            }
            int n6 = element.getStartOffset();
            int n7 = element.getEndOffset() - n6;
            string = styledDocument.getText(n6, n7);
            for (n5 = n3; n5 > 0 && (Character.isJavaIdentifierPart(string.charAt(n5 - 1)) || string.charAt(n5 - 1) == '.'); --n5) {
            }
            for (n4 = n3; n4 < n7 && Character.isJavaIdentifierPart(string.charAt(n4)); ++n4) {
            }
            if (n5 == n4) {
                return null;
            }
            return string.substring(n5, n4);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private static class MyTrees
    extends Trees {
        Trees trees;
        private CompilationController controller;
        private JPDADebugger debugger;

        MyTrees(Trees trees, CompilationController compilationController, JPDADebugger jPDADebugger) {
            this.trees = trees;
            this.controller = compilationController;
            this.debugger = jPDADebugger;
        }

        @Override
        public SourcePositions getSourcePositions() {
            return this.trees.getSourcePositions();
        }

        @Override
        public Tree getTree(javax.lang.model.element.Element element) {
            return this.trees.getTree(element);
        }

        @Override
        public ClassTree getTree(TypeElement typeElement) {
            return this.trees.getTree(typeElement);
        }

        @Override
        public MethodTree getTree(ExecutableElement executableElement) {
            return this.trees.getTree(executableElement);
        }

        @Override
        public Tree getTree(javax.lang.model.element.Element element, AnnotationMirror annotationMirror) {
            return this.trees.getTree(element, annotationMirror);
        }

        @Override
        public Tree getTree(javax.lang.model.element.Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
            return this.trees.getTree(element, annotationMirror, annotationValue);
        }

        @Override
        public TreePath getPath(CompilationUnitTree compilationUnitTree, Tree tree) {
            return this.trees.getPath(compilationUnitTree, tree);
        }

        @Override
        public TreePath getPath(javax.lang.model.element.Element element) {
            return this.trees.getPath(element);
        }

        @Override
        public TreePath getPath(javax.lang.model.element.Element element, AnnotationMirror annotationMirror) {
            return this.trees.getPath(element, annotationMirror);
        }

        @Override
        public TreePath getPath(javax.lang.model.element.Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
            return this.trees.getPath(element, annotationMirror, annotationValue);
        }

        @Override
        public javax.lang.model.element.Element getElement(TreePath treePath) {
            return this.trees.getElement(treePath);
        }

        @Override
        public TypeMirror getTypeMirror(TreePath treePath) {
            Tree tree = treePath.getLeaf();
            if (tree.getKind() == Tree.Kind.IDENTIFIER) {
                Elements elements;
                TypeElement typeElement;
                ObjectVariable objectVariable;
                Object object;
                Map map = null;
                try {
                    object = this.debugger.getClass().getMethod("getAllLabels", new Class[0]);
                    map = (Map)((Method)object).invoke((Object)this.debugger, new Object[0]);
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
                if (map != null && (objectVariable = (ObjectVariable)map.get(object = ((IdentifierTree)tree).getName().toString())) != null && (typeElement = (elements = this.controller.getElements()).getTypeElement(objectVariable.getClassType().getName())) != null) {
                    return typeElement.asType();
                }
            }
            return this.trees.getTypeMirror(treePath);
        }

        @Override
        public Scope getScope(TreePath treePath) {
            return this.trees.getScope(treePath);
        }

        @Override
        public boolean isAccessible(Scope scope, TypeElement typeElement) {
            return this.trees.isAccessible(scope, typeElement);
        }

        @Override
        public boolean isAccessible(Scope scope, javax.lang.model.element.Element element, DeclaredType declaredType) {
            return this.trees.isAccessible(scope, element, declaredType);
        }

        @Override
        public TypeMirror getOriginalType(ErrorType errorType) {
            return this.trees.getOriginalType(errorType);
        }

        @Override
        public void printMessage(Diagnostic.Kind kind, CharSequence charSequence, Tree tree, CompilationUnitTree compilationUnitTree) {
            this.trees.printMessage(kind, charSequence, tree, compilationUnitTree);
        }
    }

    private static class MyWrapperFactory
    implements WrapperFactory {
        private WeakReference<JPDADebugger> debuggerRef;
        private FileObject fileObject;

        public MyWrapperFactory(JPDADebugger jPDADebugger, FileObject fileObject, StyledDocument styledDocument) {
            this.debuggerRef = new WeakReference<JPDADebugger>(jPDADebugger);
            this.fileObject = fileObject;
        }

        private CompilationController findController(FileObject fileObject) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            if (javaSource == null) {
                return null;
            }
            final CompilationController[] compilationControllerArray = new CompilationController[]{null};
            try {
                Future future = javaSource.runWhenScanFinished((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            ErrorManager.getDefault().log(16, "Unable to resolve " + compilationController.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + compilationController.getPhase() + "\nDiagnostics = " + compilationController.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                            return;
                        }
                        compilationControllerArray[0] = compilationController;
                    }
                }, true);
                if (!future.isDone()) {
                    future.cancel(true);
                    return null;
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return null;
            }
            return compilationControllerArray[0];
        }

        public Trees wrapTrees(Trees trees) {
            JPDADebugger jPDADebugger = (JPDADebugger)this.debuggerRef.get();
            if (jPDADebugger == null) {
                return trees;
            }
            return new MyTrees(trees, this.findController(this.fileObject), jPDADebugger);
        }
    }

    private static final class Context {
        public String url;
        public int line;
        public JPDADebugger debugger;

        private Context() {
        }
    }
}

