/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class SetAsCurrentThreadGutterAction
extends SystemAction
implements ContextAwareAction {
    public SetAsCurrentThreadGutterAction() {
        this.setEnabled(false);
    }

    public String getName() {
        return NbBundle.getMessage(SetAsCurrentThreadGutterAction.class, (String)"CTL_setAsCurrentThread");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public Action createContextAwareInstance(Lookup lookup) {
        Collection collection = lookup.lookupAll(Lookup.Provider.class);
        ArrayList<JPDAThread> arrayList = new ArrayList<JPDAThread>(collection.size());
        for (Lookup.Provider provider : collection) {
            arrayList.addAll(provider.getLookup().lookupAll(JPDAThread.class));
        }
        if (arrayList.size() > 0) {
            return new ThreadAwareAction(arrayList);
        }
        return this;
    }

    private static class ThreadAwareAction
    implements Action,
    Presenter.Popup {
        private List<JPDAThread> threads;

        public ThreadAwareAction(List<JPDAThread> list) {
            this.threads = list;
        }

        private ThreadAwareAction(JPDAThread jPDAThread) {
            this.threads = Collections.singletonList(jPDAThread);
        }

        @Override
        public Object getValue(String string) {
            if ("Name".equals(string)) {
                return NbBundle.getMessage(SetAsCurrentThreadGutterAction.class, (String)"CTL_setAsCurrentThreadT", (Object)this.threads.get(0).getName());
            }
            return null;
        }

        @Override
        public void putValue(String string, Object object) {
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.threads.get(0).makeCurrent();
        }

        public JMenuItem getPopupPresenter() {
            if (this.threads.size() == 1) {
                return new Actions.MenuItem((Action)this, false);
            }
            return new MultiThreadsMenu();
        }

        private class MultiThreadsMenu
        extends JMenuItem
        implements DynamicMenuContent {
            private MultiThreadsMenu() {
            }

            public JComponent[] getMenuPresenters() {
                JComponent[] jComponentArray = new JComponent[ThreadAwareAction.this.threads.size()];
                for (int i = 0; i < jComponentArray.length; ++i) {
                    jComponentArray[i] = new ThreadAwareAction((JPDAThread)ThreadAwareAction.this.threads.get(i)).getPopupPresenter();
                }
                return jComponentArray;
            }

            public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
                return jComponentArray;
            }
        }
    }
}

