/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.EventQueue;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.awt.Actions;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProjectAction
extends LookupSensitiveAction
implements ContextAwareAction {
    private String command;
    private ProjectActionPerformer performer;
    private final String namePattern;
    private final String popupPattern;

    public ProjectAction(String command, String namePattern, Icon icon, Lookup lookup) {
        this(command, null, namePattern, null, icon, lookup);
    }

    public ProjectAction(String command, String namePattern, String popupPattern, Icon icon, Lookup lookup) {
        this(command, null, namePattern, popupPattern, icon, lookup);
    }

    public ProjectAction(ProjectActionPerformer performer, String namePattern, Icon icon, Lookup lookup) {
        this(null, performer, namePattern, null, icon, lookup);
    }

    private ProjectAction(ProjectActionPerformer performer, String namePattern, String popupPattern, Icon icon, Lookup lookup) {
        this(null, performer, namePattern, popupPattern, icon, lookup);
    }

    private ProjectAction(String command, ProjectActionPerformer performer, String namePattern, String popupPattern, Icon icon, Lookup lookup) {
        super(icon, lookup, new Class[]{Project.class, DataObject.class});
        this.command = command;
        if (command != null) {
            ActionsUtil.SHORCUTS_MANAGER.registerAction(command, this);
        }
        this.performer = performer;
        this.namePattern = namePattern;
        this.popupPattern = popupPattern;
        String presenterName = ActionsUtil.formatName(this.getNamePattern(), 0, "");
        this.setDisplayName(presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)presenterName));
    }

    @Override
    public final void putValue(String key, Object value) {
        super.putValue(key, value);
        if ("AcceleratorKey".equals(key)) {
            ActionsUtil.SHORCUTS_MANAGER.registerShortcut(this.command, value);
        }
    }

    @Override
    protected void actionPerformed(Lookup context) {
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, this.command);
        if (projects.length == 1) {
            if (this.command != null) {
                ActionProvider ap = (ActionProvider)projects[0].getLookup().lookup(ActionProvider.class);
                LogRecord r = new LogRecord(Level.FINE, "PROJECT_ACTION");
                r.setResourceBundle(NbBundle.getBundle(ProjectAction.class));
                r.setParameters(new Object[]{this.getClass().getName(), projects[0].getClass().getName(), this.getValue("Name")});
                r.setLoggerName(UILOG.getName());
                UILOG.log(r);
                ap.invokeAction(this.command, Lookup.EMPTY);
            } else if (this.performer != null) {
                this.performer.perform(projects[0]);
            }
        }
    }

    @Override
    protected void refresh(Lookup context) {
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, this.command);
        if (this.command != null) {
            this.enable(projects.length == 1);
        } else if (this.performer != null && projects.length == 1) {
            this.enable(this.performer.enable(projects[0]));
        } else {
            this.enable(false);
        }
        String presenterName = ActionsUtil.formatProjectSensitiveName(this.namePattern, projects);
        this.putValue("menuText", presenterName);
        if (this.popupPattern != null) {
            String popupName = ActionsUtil.formatProjectSensitiveName(this.popupPattern, projects);
            this.putValue("popupText", popupName);
        }
        this.putValue("ShortDescription", Actions.cutAmpersand((String)presenterName));
    }

    private void enable(final boolean enable) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectAction.this.setEnabled(enable);
                }
            });
        } else {
            this.setEnabled(enable);
        }
    }

    protected final String getCommand() {
        return this.command;
    }

    protected final String getNamePattern() {
        return this.namePattern;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        ProjectAction a = new ProjectAction(this.command, this.performer, this.namePattern, this.popupPattern, (Icon)this.getValue("SmallIcon"), actionContext);
        a.putValue("hideWhenDisabled", this.getValue("hideWhenDisabled"));
        return a;
    }
}

