/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.actions;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.vmd.api.flow.FlowSupport;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ExportFlowAsImageAction
extends SystemAction
implements DesignDocumentAwareness {
    private DesignDocument document;

    public String getName() {
        return NbBundle.getMessage(ExportFlowAsImageAction.class, (String)"NAME_ExportFlowAsImage");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ExportFlowAsImageAction.class);
    }

    public boolean isEnabled() {
        this.updateDesignDocumentReference();
        FlowScene flowScene = FlowSupport.getFlowSceneForDocument((DesignDocument)this.document);
        if (flowScene == null) {
            return false;
        }
        JComponent jComponent = flowScene.getView();
        if (jComponent == null || !jComponent.isShowing()) {
            return false;
        }
        Rectangle rectangle = flowScene.getBounds();
        return rectangle.width > 0 && rectangle.height > 0;
    }

    private void updateDesignDocumentReference() {
        DataObjectContext dataObjectContext = ActiveViewSupport.getDefault().getActiveView().getContext();
        dataObjectContext.addDesignDocumentAwareness((DesignDocumentAwareness)this);
        dataObjectContext.removeDesignDocumentAwareness((DesignDocumentAwareness)this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.updateDesignDocumentReference();
        FlowScene flowScene = FlowSupport.getFlowSceneForDocument((DesignDocument)this.document);
        if (flowScene == null) {
            return;
        }
        this.saveAsImage((Scene)flowScene);
    }

    /*
     * Loose catch block
     */
    private void saveAsImage(Scene scene) {
        block19: {
            FileImageOutputStream fileImageOutputStream;
            Rectangle rectangle = scene.getBounds();
            BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 6);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            scene.paint(graphics2D);
            graphics2D.dispose();
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(NbBundle.getMessage(ExportFlowAsImageAction.class, (String)"TITLE_ExportFlowAsImage"));
            jFileChooser.setDialogType(1);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".png");
                }

                @Override
                public String getDescription() {
                    return NbBundle.getMessage(ExportFlowAsImageAction.class, (String)"LBL_FileFilterPNG");
                }
            });
            if (jFileChooser.showSaveDialog(scene.getView()) != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".png")) {
                file = new File(file.getParentFile(), file.getName() + ".png");
            }
            if (file.exists()) {
                fileImageOutputStream = new DialogDescriptor((Object)NbBundle.getMessage(ExportFlowAsImageAction.class, (String)"LBL_AlreadyExists", (Object)file.getAbsolutePath()), NbBundle.getMessage(ExportFlowAsImageAction.class, (String)"TITLE_AlreadyExists"), true, 0, DialogDescriptor.NO_OPTION, null);
                DialogDisplayer.getDefault().createDialog((DialogDescriptor)fileImageOutputStream).setVisible(true);
                if (fileImageOutputStream.getValue() != DialogDescriptor.YES_OPTION) {
                    return;
                }
            }
            fileImageOutputStream = null;
            fileImageOutputStream = new FileImageOutputStream(file);
            ImageIO.write((RenderedImage)bufferedImage, "png", fileImageOutputStream);
            try {
                if (fileImageOutputStream != null) {
                    fileImageOutputStream.close();
                }
                break block19;
            }
            catch (IOException iOException) {
                Debug.error((Object[])new Object[]{iOException});
            }
            break block19;
            catch (FileNotFoundException fileNotFoundException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportFlowAsImageAction.class, (String)"LBL_NoWrite", (Object)file.getAbsolutePath()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                try {
                    if (fileImageOutputStream != null) {
                        fileImageOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Debug.error((Object[])new Object[]{iOException});
                }
                return;
            }
            catch (IOException iOException) {
                throw Debug.error((Object[])new Object[]{iOException});
                {
                    catch (Throwable throwable) {
                        try {
                            if (fileImageOutputStream != null) {
                                fileImageOutputStream.close();
                            }
                        }
                        catch (IOException iOException2) {
                            Debug.error((Object[])new Object[]{iOException2});
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    public void setDesignDocument(DesignDocument designDocument) {
        this.document = designDocument;
    }
}

