/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.awt.Color;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.db.sql.visualeditor.Log;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderInputTable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;

public class QueryBuilderResultTable
extends JTable
implements ActionListener,
KeyListener {
    private DefaultTableModel resultTableModel = null;
    private QueryBuilder _queryBuilder;
    private JPopupMenu resultTablePopup;

    public QueryBuilderResultTable() {
        this((QueryBuilder)null);
    }

    public QueryBuilderResultTable(QueryBuilder queryBuilder) {
        this._queryBuilder = queryBuilder;
        this.resultTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.setModel(this.resultTableModel);
        this.resultTablePopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"LBL_CopyCellValue"));
        menuItem.addActionListener(this);
        this.resultTablePopup.add(menuItem);
        menuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"LBL_CopyRowValues"));
        menuItem.addActionListener(this);
        this.resultTablePopup.add(menuItem);
        ResultTablePopupListener resultTablePopupListener = new ResultTablePopupListener();
        super.addMouseListener(resultTablePopupListener);
        this.setAutoResizeMode(0);
        this.setForeground(Color.DARK_GRAY);
        this.addKeyListener(this);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this._queryBuilder != null) {
            this._queryBuilder.handleKeyPress(e);
        }
    }

    void clearModel() {
        ((DefaultTableModel)this.getModel()).setRowCount(0);
    }

    public void displayResultSet(ResultSet rs) {
        this.displayResultSet(rs, 40, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean displayResultSet(ResultSet rs, int maxEntries, boolean infoMsgIfTruncated) {
        boolean resultsTruncated = false;
        try {
            ResultSetMetaData rsmd;
            if (rs == null || (rsmd = rs.getMetaData()) == null) {
                Log.getLogger().warning("Exception - unable to get query result ! ");
                boolean bl = resultsTruncated;
                return bl;
            }
            int numberOfColumns = rsmd.getColumnCount();
            Log.getLogger().finest(" rsmd.getColumnCount(): " + numberOfColumns);
            Object[] dbColumnNames = new String[numberOfColumns];
            for (int i = 1; i <= numberOfColumns; ++i) {
                dbColumnNames[i - 1] = rsmd.getColumnLabel(i);
            }
            this.resultTableModel.setColumnIdentifiers(dbColumnNames);
            this.resultTableModel.setRowCount(0);
            for (int count = 0; rs.next() && count < maxEntries + 1; ++count) {
                if (count >= maxEntries) {
                    resultsTruncated = true;
                    break;
                }
                Object[] row = new Object[numberOfColumns];
                for (int i = 1; i <= numberOfColumns; ++i) {
                    if (rsmd.getColumnType(i) == 2004) {
                        Blob blobData = rs.getBlob(i);
                        if (blobData == null) continue;
                        row[i - 1] = "[BLOB of size " + blobData.length() + "]";
                        continue;
                    }
                    if (rsmd.getColumnType(i) == 2005) {
                        Clob clobData = rs.getClob(i);
                        if (clobData == null) continue;
                        row[i - 1] = "[CLOB of size " + clobData.length() + "]";
                        continue;
                    }
                    if (rsmd.getColumnType(i) == 93) {
                        Timestamp timeStampData = rs.getTimestamp(i);
                        if (timeStampData == null) continue;
                        row[i - 1] = DateFormat.getDateTimeInstance(3, 2).format(timeStampData);
                        continue;
                    }
                    if (rsmd.getColumnType(i) == 91) {
                        Date dateData = rs.getDate(i);
                        if (dateData == null) continue;
                        row[i - 1] = DateFormat.getDateInstance(3).format(dateData);
                        continue;
                    }
                    if (rsmd.getColumnType(i) == 92) {
                        Time timeData = rs.getTime(i);
                        if (timeData == null) continue;
                        row[i - 1] = DateFormat.getTimeInstance(2).format(timeData);
                        continue;
                    }
                    row[i - 1] = rs.getObject(i);
                }
                this.resultTableModel.addRow(row);
            }
            if (resultsTruncated && infoMsgIfTruncated) {
                String msg = NbBundle.getMessage(QueryBuilderResultTable.class, (String)"MAX_ENTRIES_DISPLAYED", (Object)Integer.toString(maxEntries));
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)(msg + "\n\n"), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            Log.getLogger().warning("Exception - unable to build table");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exc) {}
            }
        }
        return resultsTruncated;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        if (source.getText().equals(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"LBL_CopyCellValue"))) {
            Object o = this.getValueAt(this.getSelectedRow(), this.getSelectedColumn());
            this.setClipboard(o.toString());
        } else if (source.getText().equals(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"LBL_CopyRowValues"))) {
            int[] rows = this.getSelectedRows();
            StringBuffer output = new StringBuffer();
            for (int i = 0; i < rows.length; ++i) {
                for (int col = 0; col < this.getColumnCount(); ++col) {
                    if (col > 0) {
                        output.append('\t');
                    }
                    Object o = this.getValueAt(rows[i], col);
                    output.append(o.toString());
                }
                output.append('\n');
            }
            this.setClipboard(output.toString());
        }
    }

    private void setClipboard(String contents) {
        ExClipboard clipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
        StringSelection strSel = new StringSelection(contents);
        clipboard.setContents((Transferable)strSel, (ClipboardOwner)strSel);
    }

    class ResultTablePopupListener
    extends MouseAdapter {
        ResultTablePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mousePressed(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JTable source = (JTable)e.getSource();
                int row = source.rowAtPoint(e.getPoint());
                int column = source.columnAtPoint(e.getPoint());
                if (row != -1) {
                    source.setRowSelectionInterval(row, row);
                }
                QueryBuilderResultTable.this.resultTablePopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

