/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.modules.parsing.impl.indexing.CancelRequest;
import org.netbeans.modules.parsing.impl.indexing.DeletedIndexable;
import org.netbeans.modules.parsing.impl.indexing.IndexableImpl;
import org.netbeans.modules.parsing.impl.indexing.TimeStamps;
import org.openide.filesystems.FileObject;

public abstract class Crawler {
    private final URL root;
    private final boolean checkTimeStamps;
    private final TimeStamps timeStamps;
    private final CancelRequest cancelRequest;
    private Collection<IndexableImpl> resources;
    private Collection<IndexableImpl> allResources;
    private Collection<IndexableImpl> deleted;
    private boolean finished;

    protected Crawler(URL root, boolean checkTimeStamps, boolean detectDeletedFiles, CancelRequest cancelRequest) throws IOException {
        this.root = root;
        this.checkTimeStamps = checkTimeStamps;
        this.timeStamps = TimeStamps.forRoot(root, detectDeletedFiles);
        this.cancelRequest = cancelRequest;
    }

    public final Collection<IndexableImpl> getResources() throws IOException {
        this.init();
        return this.checkTimeStamps ? this.resources : this.allResources;
    }

    public final Collection<IndexableImpl> getAllResources() throws IOException {
        this.init();
        return this.allResources;
    }

    public final Collection<IndexableImpl> getDeletedResources() throws IOException {
        this.init();
        return this.deleted;
    }

    public final void storeTimestamps() throws IOException {
        this.init();
        this.timeStamps.store();
    }

    public final boolean isFinished() throws IOException {
        this.init();
        return this.finished;
    }

    protected final boolean isUpToDate(FileObject f, String relativePath) {
        boolean upToDate = this.timeStamps.checkAndStoreTimestamp(f, relativePath);
        return this.checkTimeStamps ? upToDate : false;
    }

    protected final boolean isCancelled() {
        return this.cancelRequest.isRaised();
    }

    protected abstract boolean collectResources(Collection<IndexableImpl> var1, Collection<IndexableImpl> var2);

    private void init() throws IOException {
        if (this.resources == null) {
            LinkedHashSet<IndexableImpl> _resources = this.checkTimeStamps ? new LinkedHashSet<IndexableImpl>() : null;
            LinkedHashSet<IndexableImpl> _allResources = new LinkedHashSet<IndexableImpl>();
            this.finished = this.collectResources(_resources, _allResources);
            this.resources = this.checkTimeStamps ? Collections.unmodifiableCollection(_resources) : null;
            this.allResources = Collections.unmodifiableCollection(_allResources);
            Set<String> unseen = this.timeStamps.getUnseenFiles();
            if (unseen != null) {
                this.deleted = new ArrayList<IndexableImpl>(unseen.size());
                for (String u : unseen) {
                    this.deleted.add(new DeletedIndexable(this.root, u));
                }
                this.deleted = Collections.unmodifiableCollection(this.deleted);
            } else {
                this.deleted = Collections.emptySet();
            }
        }
    }
}

