/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper.swing;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileProxy;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.UiUtils;
import org.netbeans.installer.utils.exceptions.DownloadException;
import org.netbeans.installer.utils.helper.swing.NbiPanel;

public class NbiFrame
extends JFrame {
    protected int frameWidth = UiUtils.getDimension(System.getProperties(), "nbi.ui.swing.frame.width", 650);
    protected int frameMinimumWidth;
    protected int frameMaximumWidth;
    protected int frameHeight = UiUtils.getDimension(System.getProperties(), "nbi.ui.swing.frame.height", 600);
    protected int frameMinimumHeight;
    protected int frameMaximumHeight;
    protected File frameIcon;
    private NbiFrameContentPane contentPane;
    public static final String FRAME_WIDTH_PROPERTY = "nbi.ui.swing.frame.width";
    public static final String FRAME_MINIMUM_WIDTH_PROPERTY = "nbi.ui.swing.frame.minimum.width";
    public static final String FRAME_MAXIMUM_WIDTH_PROPERTY = "nbi.ui.swing.frame.maximum.width";
    public static final String FRAME_HEIGHT_PROPERTY = "nbi.ui.swing.frame.height";
    public static final String FRAME_MINIMUM_HEIGHT_PROPERTY = "nbi.ui.swing.frame.minimum.height";
    public static final String FRAME_MAXIMUM_HEIGHT_PROPERTY = "nbi.ui.swing.frame.maximum.height";
    public static final String FRAME_ICON_URI_PROPERTY = "nbi.ui.swing.frame.icon.uri";
    public static final int DEFAULT_FRAME_WIDTH = 650;
    public static final int DEFAULT_FRAME_MINIMUM_WIDTH = 650;
    public static final int DEFAULT_FRAME_MAXIMUM_WIDTH = -1;
    public static final int DEFAULT_FRAME_HEIGHT = 600;
    public static final int DEFAULT_FRAME_MINIMUM_HEIGHT = 600;
    public static final int DEFAULT_FRAME_MAXIMUM_HEIGHT = -1;
    public static final String DEFAULT_FRAME_ICON_URI = "resource:org/netbeans/installer/utils/helper/swing/frame-icon.png";
    private static final String RESOURCE_FAILED_TO_DOWNLOAD_WIZARD_ICON = "NF.error.failed.to.download.icon";
    private static final String RESOURCE_FAILED_TO_SET_FRAME_ICON = "NF.error.failed.to.set.frame.icon";

    public NbiFrame() {
        String frameIconUri;
        this.frameMinimumWidth = UiUtils.getDimension(System.getProperties(), FRAME_MINIMUM_WIDTH_PROPERTY, 650);
        this.frameMinimumHeight = UiUtils.getDimension(System.getProperties(), FRAME_MINIMUM_HEIGHT_PROPERTY, 600);
        this.frameMaximumWidth = UiUtils.getDimension(System.getProperties(), FRAME_MAXIMUM_WIDTH_PROPERTY, -1);
        this.frameMaximumHeight = UiUtils.getDimension(System.getProperties(), FRAME_MAXIMUM_HEIGHT_PROPERTY, -1);
        boolean customIconLoaded = false;
        if (System.getProperty(FRAME_ICON_URI_PROPERTY) != null) {
            frameIconUri = System.getProperty(FRAME_ICON_URI_PROPERTY);
            try {
                this.frameIcon = FileProxy.getInstance().getFile(frameIconUri, true);
                customIconLoaded = true;
            }
            catch (DownloadException e) {
                ErrorManager.notifyWarning(ResourceUtils.getString(NbiFrame.class, RESOURCE_FAILED_TO_DOWNLOAD_WIZARD_ICON, frameIconUri), e);
            }
        }
        if (!customIconLoaded) {
            frameIconUri = DEFAULT_FRAME_ICON_URI;
            try {
                this.frameIcon = FileProxy.getInstance().getFile(DEFAULT_FRAME_ICON_URI, true);
                customIconLoaded = true;
            }
            catch (DownloadException e) {
                ErrorManager.notifyWarning(ResourceUtils.getString(NbiFrame.class, RESOURCE_FAILED_TO_DOWNLOAD_WIZARD_ICON, DEFAULT_FRAME_ICON_URI), e);
            }
        }
        this.initComponents();
    }

    public void setVisible(boolean visible) {
        GraphicsDevice screen = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0];
        GraphicsConfiguration config = screen.getDefaultConfiguration();
        int screenWidth = config.getBounds().width;
        int screenHeight = config.getBounds().height;
        this.setLocation((screenWidth - this.getSize().width) / 2, (screenHeight - this.getSize().height) / 2);
        super.setVisible(visible);
    }

    public Image getBackgroundImage() {
        return this.contentPane.getBackgroundImage();
    }

    public void setBackgroundImage(URL url) {
        this.contentPane.setBackgroundImage(url);
    }

    private void initComponents() {
        try {
            this.setDefaultCloseOperation(3);
        }
        catch (SecurityException e) {
            ErrorManager.notifyDebug("Cannot set the default close operation", e);
        }
        this.setSize(this.frameWidth, this.frameHeight);
        try {
            this.setIconImage(new ImageIcon(this.frameIcon.toURI().toURL()).getImage());
        }
        catch (MalformedURLException e) {
            ErrorManager.notifyWarning(ResourceUtils.getString(NbiFrame.class, RESOURCE_FAILED_TO_SET_FRAME_ICON), e);
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent event) {
                if (NbiFrame.this.frameMinimumWidth != -1 && NbiFrame.this.getSize().width < NbiFrame.this.frameMinimumWidth) {
                    NbiFrame.this.setSize(NbiFrame.this.frameMinimumWidth, NbiFrame.this.getSize().height);
                }
                if (NbiFrame.this.frameMinimumHeight != -1 && NbiFrame.this.getSize().height < NbiFrame.this.frameMinimumHeight) {
                    NbiFrame.this.setSize(NbiFrame.this.getSize().width, NbiFrame.this.frameMinimumHeight);
                }
                if (NbiFrame.this.frameMaximumWidth != -1 && NbiFrame.this.getSize().width > NbiFrame.this.frameMaximumWidth) {
                    NbiFrame.this.setSize(NbiFrame.this.frameMaximumWidth, NbiFrame.this.getSize().height);
                }
                if (NbiFrame.this.frameMaximumHeight != -1 && NbiFrame.this.getSize().height > NbiFrame.this.frameMaximumHeight) {
                    NbiFrame.this.setSize(NbiFrame.this.getSize().width, NbiFrame.this.frameMaximumHeight);
                }
            }
        });
        this.contentPane = new NbiFrameContentPane();
        this.setContentPane(this.contentPane);
    }

    public static class NbiFrameContentPane
    extends NbiPanel {
        private Image backgroundImage;

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.backgroundImage != null) {
                graphics.drawImage(this.backgroundImage, 0, 0, this);
            }
        }

        public Image getBackgroundImage() {
            return this.backgroundImage;
        }

        public void setBackgroundImage(URL url) {
            this.backgroundImage = url != null ? new ImageIcon(url).getImage() : null;
        }

        public void setBackgroundImage(Image image) {
            this.backgroundImage = image != null ? image : null;
        }
    }
}

