/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.ricoh;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.project.ricoh.dalp.DalpParser;
import org.netbeans.modules.j2me.cdc.project.ricoh.dalp.DalpParserHandler;
import org.netbeans.modules.j2me.cdc.project.ricoh.dalp.DalpParserHandlerImpl;
import org.netbeans.modules.j2me.cdc.project.ui.wizards.NewCDCProjectWizardIterator;
import org.netbeans.modules.j2me.cdc.project.ui.wizards.PanelConfigurePlatform;
import org.netbeans.modules.j2me.cdc.project.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.mobility.project.ui.wizard.NewProjectIterator;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformInstallPanel;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformSelectionPanel;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SamplesWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    static final String PROP_NAME_INDEX = "nameIndex";
    private static final String MANIFEST_FILE = "manifest.mf";
    private static final long serialVersionUID = 1L;
    private int type = 3;
    private int index;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor wiz;
    private String platform;
    private String preferredName;

    public static SamplesWizardIterator createIterator() {
        return new SamplesWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        WizardDescriptor.Panel[] panelArray;
        int i = SamplesWizardIterator.getNumberOfSuitableCdcPlatforms(this.platform);
        if (i != 0) {
            WizardDescriptor.Panel[] panelArray2 = new WizardDescriptor.Panel[2];
            panelArray2[0] = new PanelConfigurePlatform(this.platform);
            panelArray = panelArray2;
            panelArray2[1] = new PanelConfigureProject(this.type, this.preferredName);
        } else {
            WizardDescriptor.Panel[] panelArray3 = new WizardDescriptor.Panel[3];
            panelArray3[0] = new PlatformInstallPanel.WizardPanel(this.platform, "cdc");
            panelArray3[1] = new PanelConfigurePlatform(this.platform);
            panelArray = panelArray3;
            panelArray3[2] = new PanelConfigureProject(this.type, this.preferredName);
        }
        return panelArray;
    }

    private String[] createSteps() {
        String[] stringArray;
        int i = SamplesWizardIterator.getNumberOfSuitableCdcPlatforms(this.platform);
        if (i != 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_SelectPlatform");
            stringArray = stringArray2;
            stringArray2[1] = NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_ConfigureProject");
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_Step_AddPlatform");
            stringArray3[1] = NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_SelectPlatform");
            stringArray = stringArray3;
            stringArray3[2] = NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_ConfigureProject");
        }
        return stringArray;
    }

    private Properties parseRicohAdditionalResources(FileObject projectDir) {
        FileObject[] fos = projectDir.getChildren();
        for (int i = 0; i < fos.length; ++i) {
            FileObject dalp = fos[i];
            if ("dalp".compareToIgnoreCase(dalp.getExt()) != 0) continue;
            Properties properties = new Properties();
            DalpParserHandlerImpl handler = new DalpParserHandlerImpl(projectDir, properties);
            try {
                DalpParser.parse(new InputSource(dalp.getInputStream()), (DalpParserHandler)handler);
            }
            catch (FileNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (SAXException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (ParserConfigurationException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            return properties;
        }
        return null;
    }

    public Set instantiate() throws IOException {
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        File dirPr = (File)this.wiz.getProperty("projdir");
        if (dirPr != null) {
            dirPr = FileUtil.normalizeFile((File)dirPr);
        }
        String name = (String)this.wiz.getProperty("name");
        final String activePlatform = (String)this.wiz.getProperty("activePlatform");
        final String activeDevice = (String)this.wiz.getProperty("activeDevice");
        final String activeProfile = (String)this.wiz.getProperty("activeProfile");
        Properties props = (Properties)this.wiz.getProperty("additionalProperties");
        final FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        PlatformSelectionPanel.PlatformDescription pd = (PlatformSelectionPanel.PlatformDescription)this.wiz.getProperty("PlatformDescription");
        AntProjectHelper h = J2MEProjectGenerator.createProject((File)dirPr, (String)name, (PlatformSelectionPanel.PlatformDescription)pd, (J2MEProjectGenerator.ProjectGeneratorCallback)new J2MEProjectGenerator.ProjectGeneratorCallback(){

            public void doPostGeneration(Project p, final AntProjectHelper h, FileObject dir, File projectLocationFile, ArrayList<String> configurations) throws IOException {
                JavaPlatform[] platforms;
                Properties parsed;
                FileObject res;
                SamplesWizardIterator.createManifest(dir, SamplesWizardIterator.MANIFEST_FILE);
                SamplesWizardIterator.unZipFile(template.getInputStream(), dir);
                final FileObject lib = dir.getFileObject("lib");
                if (lib != null) {
                    final ReferenceHelper refHelper = (ReferenceHelper)p.getLookup().lookup(ReferenceHelper.class);
                    try {
                        ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                            public Object run() throws Exception {
                                ArrayList<String> entries = new ArrayList<String>();
                                FileObject[] libs = lib.getChildren();
                                for (int i = 0; i < libs.length; ++i) {
                                    String ref = refHelper.createForeignFileReference(FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)libs[i])), null);
                                    entries.add(ref + (i < libs.length - 1 ? ";" : ""));
                                }
                                EditableProperties editableProps = h.getProperties("nbproject/project.properties");
                                editableProps.setProperty("extra.classpath", entries.toArray(new String[entries.size()]));
                                editableProps.setProperty("libs.classpath", entries.toArray(new String[entries.size()]));
                                h.putProperties("nbproject/project.properties", editableProps);
                                return null;
                            }
                        });
                    }
                    catch (MutexException me) {
                        ErrorManager.getDefault().notify((Throwable)me);
                    }
                }
                if ((res = dir.getFileObject("resources")) != null) {
                    final ReferenceHelper refHelper = (ReferenceHelper)p.getLookup().lookup(ReferenceHelper.class);
                    try {
                        ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                            public Object run() throws Exception {
                                String ref = ";" + refHelper.createForeignFileReference(FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)res)), null);
                                EditableProperties editableProps = h.getProperties("nbproject/project.properties");
                                editableProps.setProperty("libs.classpath", editableProps.getProperty("libs.classpath") + ref);
                                h.putProperties("nbproject/project.properties", editableProps);
                                return null;
                            }
                        });
                    }
                    catch (MutexException me) {
                        ErrorManager.getDefault().notify((Throwable)me);
                    }
                }
                if ((parsed = SamplesWizardIterator.this.parseRicohAdditionalResources(dir)) != null) {
                    for (final Map.Entry<Object, Object> elem : parsed.entrySet()) {
                        final Object value = elem.getValue();
                        if (value instanceof File) {
                            final ReferenceHelper refHelper = (ReferenceHelper)p.getLookup().lookup(ReferenceHelper.class);
                            if (value == null || !((File)value).exists()) continue;
                            try {
                                ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                                    public Object run() throws Exception {
                                        String ref = refHelper.createForeignFileReference(FileUtil.normalizeFile((File)((File)value)), null);
                                        EditableProperties props = h.getProperties("nbproject/project.properties");
                                        props.put((String)elem.getKey(), ref);
                                        h.putProperties("nbproject/project.properties", props);
                                        return null;
                                    }
                                });
                            }
                            catch (MutexException me) {
                                ErrorManager.getDefault().notify((Throwable)me);
                            }
                            continue;
                        }
                        EditableProperties editableProps = h.getProperties("nbproject/project.properties");
                        editableProps.setProperty((String)elem.getKey(), String.valueOf(elem.getValue()));
                        h.putProperties("nbproject/project.properties", editableProps);
                    }
                }
                if ((platforms = JavaPlatformManager.getDefault().getPlatforms(activePlatform, new Specification("cdc", null))).length == 0) {
                    throw new IllegalArgumentException("No CDC platform installed");
                }
                CDCPlatform cdcplatform = (CDCPlatform)platforms[0];
                EditableProperties ep = h.getProperties("nbproject/project.properties");
                ep.setProperty("application.name", p.getProjectDirectory().getNameExt());
                ep.setProperty("platform.active", cdcplatform.getAntName());
                ep.setProperty("platform.active.description", cdcplatform.getDisplayName());
                ep.setProperty("platform.trigger", "CDC");
                ep.setProperty("platform.type", cdcplatform.getType());
                String classVersion = cdcplatform.getClassVersion();
                ep.setProperty("platform.device", activeDevice);
                ep.setProperty("platform.profile", activeProfile);
                NewCDCProjectWizardIterator.generatePlatformProperties((CDCPlatform)cdcplatform, (String)activeDevice, (String)activeProfile, (EditableProperties)ep);
                ep.setProperty("javac.source", classVersion != null ? classVersion : "1.2");
                ep.setProperty("javac.target", classVersion != null ? classVersion : "1.2");
                h.putProperties("nbproject/project.properties", ep);
            }
        });
        resultSet.add(h.getProjectDirectory());
        File file = dirPr = dirPr != null ? dirPr.getParentFile() : null;
        if (dirPr != null && dirPr.exists()) {
            ProjectChooser.setProjectsFolder((File)dirPr);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        FileObject template = Templates.getTemplate((WizardDescriptor)wiz);
        this.preferredName = template.getName();
        this.wiz.putProperty("name", (Object)this.preferredName);
        this.platform = (String)template.getAttribute("platform");
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(NewProjectIterator.class, (String)"TXT_SampleProject"));
        }
        this.wiz.putProperty("additionalProperties", (Object)new Properties());
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("additionalProperties", null);
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz.putProperty("mainClass", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format("{0} of {1}", new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unZipFile(InputStream source, FileObject projectRoot) throws IOException {
        try {
            ZipEntry entry;
            ZipInputStream str = new ZipInputStream(source);
            while ((entry = str.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    FileUtil.createFolder((FileObject)projectRoot, (String)entry.getName());
                    continue;
                }
                FileObject fo = FileUtil.createData((FileObject)projectRoot, (String)entry.getName());
                FileLock lock = fo.lock();
                try {
                    OutputStream out = fo.getOutputStream(lock);
                    try {
                        FileUtil.copy((InputStream)str, (OutputStream)out);
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
        }
        finally {
            source.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createManifest(FileObject dir, String path) throws IOException {
        FileObject manifest = dir.createData(MANIFEST_FILE);
        FileLock lock = manifest.lock();
        try {
            OutputStream os = manifest.getOutputStream(lock);
            try {
                PrintWriter pw = new PrintWriter(os);
                pw.println("Manifest-Version: 1.0");
                pw.println("X-COMMENT: Main-Class will be added automatically by build");
                pw.println();
                pw.flush();
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    static int getNumberOfSuitableCdcPlatforms(String platformType) {
        HashSet<String> accepted = null;
        if (platformType != null) {
            accepted = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(platformType, ",");
            while (st.hasMoreTokens()) {
                accepted.add(st.nextToken());
            }
        }
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("cdc", null));
        if (accepted == null) {
            return platforms.length;
        }
        ArrayList<JavaPlatform> plf = new ArrayList<JavaPlatform>();
        for (JavaPlatform platform : platforms) {
            if (!accepted.contains(((CDCPlatform)platform).getType())) continue;
            plf.add(platform);
        }
        return plf.size();
    }
}

