/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.ext.ffi.AbstractMemory;
import org.jruby.nb.ext.ffi.FFIProvider;
import org.jruby.nb.ext.ffi.MemoryIO;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"StructLayout"}, parent="Object")
public final class StructLayout
extends RubyObject {
    static final String CLASS_NAME = "StructLayout";
    private final Map<IRubyObject, Member> fields;
    private final int size;

    public static RubyClass createStructLayoutClass(Ruby runtime) {
        RubyModule parent = FFIProvider.getModule(runtime);
        RubyClass result = runtime.defineClassUnder(CLASS_NAME, runtime.getObject(), Allocator.INSTANCE, parent);
        result.defineAnnotatedMethods(StructLayout.class);
        result.defineAnnotatedConstants(StructLayout.class);
        return result;
    }

    StructLayout(Ruby runtime) {
        this(runtime, FFIProvider.getModule(runtime).fastGetClass(CLASS_NAME));
    }

    StructLayout(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
        this.size = 0;
        this.fields = Collections.emptyMap();
    }

    StructLayout(Ruby runtime, Map<IRubyObject, Member> fields, int size) {
        super(runtime, FFIProvider.getModule(runtime).fastGetClass(CLASS_NAME));
        this.fields = StructLayout.immutableMap(fields);
        this.size = size;
    }

    private static Map<IRubyObject, Member> immutableMap(Map<IRubyObject, Member> fields) {
        LinkedHashMap<IRubyObject, Member> tmp = new LinkedHashMap<IRubyObject, Member>(fields.size());
        for (Map.Entry<IRubyObject, Member> e : fields.entrySet()) {
            tmp.put(StructLayout.convertKey(e.getKey().getRuntime(), e.getKey()), e.getValue());
        }
        return Collections.unmodifiableMap(tmp);
    }

    private static IRubyObject convertKey(Ruby runtime, IRubyObject key) {
        if (key instanceof RubySymbol) {
            return key;
        }
        return runtime.getSymbolTable().getSymbol(key.asJavaString());
    }

    @JRubyMethod(name={"get"}, required=2)
    public IRubyObject get(ThreadContext context, IRubyObject ptr, IRubyObject name) {
        return this.getMember(context.getRuntime(), name).get(context.getRuntime(), ptr);
    }

    @JRubyMethod(name={"put"}, required=3)
    public IRubyObject put(ThreadContext context, IRubyObject ptr, IRubyObject name, IRubyObject value) {
        this.getMember(context.getRuntime(), name).put(context.getRuntime(), ptr, value);
        return value;
    }

    @JRubyMethod(name={"members"})
    public IRubyObject members(ThreadContext context) {
        return RubyArray.newArray(context.getRuntime(), this.fields.keySet());
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext context) {
        return RubyFixnum.newFixnum(context.getRuntime(), this.size);
    }

    private Member getMember(Ruby runtime, IRubyObject name) {
        Member f = this.fields.get(StructLayout.convertKey(runtime, name));
        if (f != null) {
            return f;
        }
        throw runtime.newArgumentError("Unknown field: " + name);
    }

    static abstract class Member {
        protected final long offset;

        protected Member(long offset) {
            this.offset = offset;
        }

        static final MemoryIO getMemoryIO(IRubyObject ptr) {
            return ((AbstractMemory)ptr).getMemoryIO();
        }

        public abstract void put(Ruby var1, IRubyObject var2, IRubyObject var3);

        public abstract IRubyObject get(Ruby var1, IRubyObject var2);
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        @Override
        public final IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new StructLayout(runtime, klass);
        }
    }
}

