/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.todo.settings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public final class Settings {
    public static final String PROP_PATTERN_LIST = "patternList";
    public static final String PROP_SCAN_COMMENTS_ONLY = "scanCommentsOnly";
    private static Settings theInstance;
    private static final String PATTERN_DELIMITER = "|";
    private ArrayList<String> patterns = new ArrayList(10);
    private Map<String, CommentTags> ext2comments = new HashMap<String, CommentTags>(10);
    private Map<String, CommentTags> mime2comments = new HashMap<String, CommentTags>(10);
    private boolean scanCommentsOnly = true;
    private PropertyChangeSupport propertySupport;

    private Settings() {
        this.patterns.addAll(Settings.decodePatterns(this.getPreferences().get("patterns", "@todo|TODO|FIXME|XXX|PENDING|<<<<<<<")));
        this.scanCommentsOnly = this.getPreferences().getBoolean(PROP_SCAN_COMMENTS_ONLY, true);
        this.ext2comments.put("JAVA", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("JS", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("C", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("CPP", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("CXX", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("CC", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("H", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("HPP", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("HTML", new CommentTags("<!--", "-->"));
        this.ext2comments.put("HTM", new CommentTags("<!--", "-->"));
        this.ext2comments.put("XML", new CommentTags("<!--", "-->"));
        this.ext2comments.put("JSP", new CommentTags("<%--", "--%>"));
        this.ext2comments.put("CSS", new CommentTags("/*", "*/"));
        this.ext2comments.put("PROPERTIES", new CommentTags("#"));
        this.ext2comments.put("SH", new CommentTags("#"));
        this.ext2comments.put("RB", new CommentTags("#"));
        this.ext2comments.put("PHP", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("SCALA", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("GROOVY", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("FX", new CommentTags("//", "/*", "*/"));
        this.mime2comments.put("text/x-java", new CommentTags("//", "/*", "*/"));
        this.mime2comments.put("text/html", new CommentTags("<!--", "-->"));
        this.mime2comments.put("application/x-httpd-eruby", new CommentTags("<!--", "-->"));
        this.mime2comments.put("text/x-yaml", new CommentTags("#"));
        this.mime2comments.put("text/x-python", new CommentTags("#"));
        this.mime2comments.put("text/x-fx", new CommentTags("//", "/*", "*/"));
        this.mime2comments.put("text/x-ruby", new CommentTags("#"));
        this.mime2comments.put("text/x-php5", new CommentTags("//", "/*", "*/"));
        this.mime2comments.put("text/sh", new CommentTags("#"));
    }

    public static final Settings getDefault() {
        if (null == theInstance) {
            theInstance = new Settings();
        }
        return theInstance;
    }

    public Collection<String> getPatterns() {
        return Collections.unmodifiableCollection(this.patterns);
    }

    public void setPatterns(Collection<String> newPatterns) {
        this.patterns.clear();
        this.patterns.addAll(newPatterns);
        this.getPreferences().put("patterns", Settings.encodePatterns(newPatterns));
        if (null == this.propertySupport) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.firePropertyChange(PROP_PATTERN_LIST, null, this.getPatterns());
    }

    public boolean isExtensionSupported(String fileExtension) {
        return null != this.ext2comments.get(fileExtension.toUpperCase());
    }

    public boolean isMimeTypeSupported(String mimeType) {
        return null != this.mime2comments.get(mimeType);
    }

    public String getLineComment(String fileExtension, String mime) {
        CommentTags ct = this.ext2comments.get(fileExtension.toUpperCase());
        if (null == ct) {
            ct = this.mime2comments.get(mime);
        }
        return null == ct ? null : ct.lineComment;
    }

    public String getBlockCommentStart(String fileExtension, String mime) {
        CommentTags ct = this.ext2comments.get(fileExtension.toUpperCase());
        if (null == ct) {
            ct = this.mime2comments.get(mime);
        }
        return null == ct ? null : ct.blockCommentStart;
    }

    public String getBlockCommentEnd(String fileExtension, String mime) {
        CommentTags ct = this.ext2comments.get(fileExtension.toUpperCase());
        if (null == ct) {
            ct = this.mime2comments.get(mime);
        }
        return null == ct ? null : ct.blockCommentEnd;
    }

    public boolean isScanCommentsOnly() {
        return this.scanCommentsOnly;
    }

    public void setScanCommentsOnly(boolean val) {
        boolean oldVal = this.scanCommentsOnly;
        this.scanCommentsOnly = val;
        this.getPreferences().putBoolean(PROP_SCAN_COMMENTS_ONLY, val);
        if (null == this.propertySupport) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.firePropertyChange(PROP_SCAN_COMMENTS_ONLY, oldVal, val);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (null == this.propertySupport) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (null != this.propertySupport) {
            this.propertySupport.removePropertyChangeListener(l);
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(Settings.class);
    }

    private static Collection<String> decodePatterns(String encodedPatterns) {
        StringTokenizer st = new StringTokenizer(encodedPatterns, PATTERN_DELIMITER, false);
        ArrayList<String> patterns = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String im = st.nextToken();
            patterns.add(im);
        }
        return patterns;
    }

    private static String encodePatterns(Collection<String> patterns) {
        StringBuffer sb = new StringBuffer();
        for (String p : patterns) {
            sb.append(p);
            sb.append(PATTERN_DELIMITER);
        }
        return sb.toString();
    }

    private static class CommentTags {
        private String lineComment;
        private String blockCommentStart;
        private String blockCommentEnd;

        public CommentTags(String lineComment, String blockCommentStart, String blockCommentEnd) {
            this.lineComment = lineComment;
            this.blockCommentStart = blockCommentStart;
            this.blockCommentEnd = blockCommentEnd;
        }

        public CommentTags(String blockCommentStart, String blockCommentEnd) {
            this.blockCommentStart = blockCommentStart;
            this.blockCommentEnd = blockCommentEnd;
        }

        public CommentTags(String lineComment) {
            this.lineComment = lineComment;
        }
    }
}

