/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.versioning.Accessor;
import org.netbeans.modules.versioning.FlatFolder;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public class Utils {
    private static final RequestProcessor vcsBlockingRequestProcessor = new RequestProcessor("Versioning long tasks", 1);
    private static FileSystem filesystem;

    public static VCSContext contextForLookup(Lookup lookup) {
        Lookup.Result result = lookup.lookup(new Lookup.Template(Node.class));
        Collection nodes = result.allInstances();
        return VCSContext.forNodes(nodes.toArray(new Node[nodes.size()]));
    }

    public static VCSContext contextForFileObjects(Set<? extends FileObject> files) {
        HashSet<File> roots = new HashSet<File>(files.size());
        if (files instanceof NonRecursiveFolder) {
            FileObject folder = ((NonRecursiveFolder)files).getFolder();
            roots.add(new FlatFolder(FileUtil.toFile((FileObject)folder).getAbsolutePath()));
        } else {
            for (FileObject fileObject : files) {
                roots.add(FileUtil.toFile((FileObject)fileObject));
            }
        }
        return Accessor.VCSContextAccessor.createContextForFiles(roots, files);
    }

    public static boolean isAncestorOrEqual(File ancestor, File file) {
        if (VersioningSupport.isFlat(ancestor)) {
            return ancestor.equals(file) || ancestor.equals(file.getParentFile()) && !file.isDirectory();
        }
        String filePath = file.getAbsolutePath();
        String ancestorPath = ancestor.getAbsolutePath();
        if (Utilities.isWindows() ? filePath.indexOf("~") < 0 && ancestorPath.indexOf("~") < 0 && filePath.length() < ancestorPath.length() : (Utilities.isMac() ? filePath.length() < ancestorPath.length() : !filePath.startsWith(ancestorPath))) {
            return false;
        }
        while (file != null) {
            if (file.equals(ancestor)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public static JMenuItem toMenuItem(Action action) {
        JMenuItem item;
        if (action instanceof Presenter.Menu) {
            item = ((Presenter.Menu)action).getMenuPresenter();
        } else {
            item = new JMenuItem();
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
        }
        return item;
    }

    public static File getTempFolder() {
        File dir;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        while ((dir = new File(tmpDir, "vcs-" + Long.toString(System.currentTimeMillis()))).exists() || !dir.mkdirs()) {
        }
        dir.deleteOnExit();
        return FileUtil.normalizeFile((File)dir);
    }

    public static void deleteRecursively(File file) {
        Utils.deleteRecursively(file, Level.WARNING);
    }

    public static void deleteRecursively(File file, Level level) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return;
        }
        try {
            fo.delete();
        }
        catch (IOException e) {
            Logger.getLogger(Utils.class.getName()).log(level, "", e);
        }
    }

    public static boolean isLocalHistory(VersioningSystem system) {
        return system.getProperty("Boolean VCS.LocalHistory") != null;
    }

    public static Reader getDocumentReader(final Document doc) {
        final String[] str = new String[1];
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    str[0] = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        };
        doc.render(run);
        return new StringReader(str[0]);
    }

    public static RequestProcessor.Task createTask(Runnable runnable) {
        return vcsBlockingRequestProcessor.create(runnable);
    }

    public static String getDisplayName(VersioningSystem system) {
        return (String)system.getProperty("String VCS.DisplayName");
    }

    public static String getMenuLabel(VersioningSystem system) {
        return (String)system.getProperty("String VCS.MenuLabel");
    }

    public static JSeparator createJSeparator() {
        JMenu menu = new JMenu();
        menu.addSeparator();
        return (JSeparator)menu.getPopupMenu().getComponent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFile(File file) {
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = file.isFile();
            return bl;
        }
        finally {
            Utils.logLasting(file, System.currentTimeMillis() - startTime, "Utils.isFile: java.io.File.isFile takes too much time ({0} ms): {1}, stacktrace:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(File file) {
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = file.exists();
            return bl;
        }
        finally {
            Utils.logLasting(file, System.currentTimeMillis() - startTime, "Utils.exists: java.io.File.exists takes too much time ({0} ms): {1}, stacktrace:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File file) {
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = file.canWrite();
            return bl;
        }
        finally {
            Utils.logLasting(file, System.currentTimeMillis() - startTime, "Utils.canWrite: java.io.File.canWrite takes too much time ({0} ms): {1}, stacktrace:");
        }
    }

    public static Integer getPriority(VersioningSystem vs) {
        Object o;
        Integer priority = null;
        if (vs != null && (o = vs.getProperty("Integer VCS.Priority")) instanceof Integer) {
            priority = (Integer)o;
        }
        if (priority == null || priority <= 0) {
            priority = Integer.MAX_VALUE;
        }
        return priority;
    }

    static FileSystem getRootFilesystem() {
        if (filesystem == null) {
            try {
                String userDir = System.getProperty("netbeans.user");
                FileObject fo = FileUtil.toFileObject((File)new File(userDir));
                filesystem = fo.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                VersioningManager.LOG.log(Level.WARNING, null, ex);
            }
        }
        return filesystem;
    }

    private static void logLasting(File file, long last, String message) {
        boolean allowed = false;
        if (!$assertionsDisabled) {
            allowed = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (allowed && last > 1500L) {
            StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (StackTraceElement e : stElements) {
                if (i++ <= 1) continue;
                if (i == 8) {
                    sb.append("...\n");
                    break;
                }
                sb.append(e.toString() + "\n");
            }
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, message, new String[]{Long.toString(last), file.getAbsolutePath()});
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, sb.toString());
        }
    }
}

