/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.hyperlink;

import javax.swing.text.Document;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.hibernate.hyperlink.HyperlinkEnv;
import org.netbeans.modules.hibernate.hyperlink.HyperlinkProcessor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class ResourceHyperlinkProcessor
extends HyperlinkProcessor {
    @Override
    public void process(HyperlinkEnv hyperlinkEnv) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)hyperlinkEnv.getDocument());
        if (fileObject == null) {
            return;
        }
        FileObject fileObject2 = fileObject.getParent();
        if (!this.openFile(fileObject2.getFileObject(hyperlinkEnv.getValueString()))) {
            String string = NbBundle.getMessage(ResourceHyperlinkProcessor.class, (String)"LBL_ResourceNotFound", (Object)hyperlinkEnv.getValueString());
            StatusDisplayer.getDefault().setStatusText(string);
        }
    }

    private boolean openFile(FileObject fileObject) {
        DataObject dataObject;
        if (fileObject == null) {
            return false;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return false;
        }
        editorCookie.open();
        return true;
    }
}

