/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;

public final class CsmRefactoringUtils {
    public static final boolean REFACTORING_EXTRA = CndUtils.getBoolean((String)"cnd.refactoring.extra", (boolean)false);

    private CsmRefactoringUtils() {
    }

    public static boolean isElementInOpenProject(FileObject f) {
        if (f == null) {
            return false;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)f);
        return OpenProjects.getDefault().isProjectOpen(p);
    }

    public static boolean isRefactorable(FileObject fo) {
        return fo == null || FileUtil.getArchiveFile((FileObject)fo) == null && fo.canWrite();
    }

    public static CsmObject convertToCsmObjectIfNeeded(CsmObject referencedObject) {
        CsmFunction decl;
        if (CsmKindUtilities.isInclude((CsmObject)referencedObject)) {
            referencedObject = ((CsmInclude)referencedObject).getIncludeFile();
        } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)referencedObject) && (decl = CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)referencedObject))) != null) {
            referencedObject = decl;
        }
        return referencedObject;
    }

    public static Collection<CsmProject> getContextCsmProjects(CsmObject contextObject) {
        HashSet<CsmProject> prjs = new HashSet<CsmProject>();
        CsmFile contextFile = null;
        if (CsmKindUtilities.isOffsetable((Object)contextObject)) {
            contextFile = ((CsmOffsetable)contextObject).getContainingFile();
        } else if (CsmKindUtilities.isFile((CsmObject)contextObject)) {
            contextFile = (CsmFile)contextObject;
        }
        CsmProject csmProject = null;
        if (contextFile != null) {
            csmProject = contextFile.getProject();
            prjs.add(csmProject);
        } else if (CsmKindUtilities.isNamespace((Object)contextObject)) {
            prjs.add(((CsmNamespace)contextObject).getProject());
        }
        return prjs;
    }

    public static Collection<CsmProject> getRelatedCsmProjects(CsmObject origObject, CsmProject p) {
        Collection<Object> out = Collections.emptyList();
        if (p != null) {
            out = Collections.singleton(p);
        } else {
            Collection all = CsmModelAccessor.getModel().projects();
            out = new HashSet(all);
        }
        return out;
    }

    public static Collection<Project> getContextProjects(CsmObject contextObject) {
        Collection<CsmProject> csmProjects = CsmRefactoringUtils.getContextCsmProjects(contextObject);
        ArrayList<Project> out = new ArrayList<Project>();
        for (CsmProject csmProject : csmProjects) {
            if (csmProject == null) continue;
            Object o = csmProject.getPlatformProject();
            if (o instanceof NativeProject) {
                o = ((NativeProject)o).getProject();
            }
            if (!(o instanceof Project)) continue;
            out.add((Project)o);
        }
        return out;
    }

    public static CsmObject getReferencedElement(CsmObject csmObject) {
        if (csmObject instanceof CsmReference) {
            return CsmRefactoringUtils.getReferencedElement(((CsmReference)csmObject).getReferencedObject());
        }
        return csmObject;
    }

    public static String getSimpleText(CsmObject element) {
        String text = "";
        if (element != null) {
            if (CsmKindUtilities.isNamedElement((CsmObject)element)) {
                text = ((Object)((CsmNamedElement)element).getName()).toString();
            } else if (CsmKindUtilities.isStatement((CsmObject)element)) {
                text = ((Object)((CsmStatement)element).getText()).toString();
            } else if (CsmKindUtilities.isOffsetable((Object)element)) {
                text = ((Object)((CsmOffsetable)element).getText()).toString();
            }
        }
        return text;
    }

    public static FileObject getFileObject(CsmObject object) {
        CsmFile container = null;
        if (CsmKindUtilities.isFile((CsmObject)object)) {
            container = (CsmFile)object;
        } else if (CsmKindUtilities.isOffsetable((Object)object)) {
            container = ((CsmOffsetable)object).getContainingFile();
        }
        return container == null ? null : CsmUtilities.getFileObject((CsmFile)container);
    }

    public static CsmObject findContextObject(Lookup lookup) {
        CsmObject out = (CsmObject)lookup.lookup(CsmObject.class);
        if (out == null) {
            Node node;
            CsmUID uid = (CsmUID)lookup.lookup(CsmUID.class);
            if (uid != null) {
                out = (CsmObject)uid.getObject();
            }
            if (out == null && (node = (Node)lookup.lookup(Node.class)) != null) {
                out = CsmReferenceResolver.getDefault().findReference(node);
            }
        }
        return out;
    }

    public static <T extends CsmObject> CsmUID<T> getHandler(T element) {
        return element == null ? null : UIDs.get(element);
    }

    public static <T> T getObject(CsmUID<T> handler) {
        return (T)(handler == null ? null : handler.getObject());
    }

    public static boolean isSupportedReference(CsmObject ref) {
        return ref != null;
    }

    public static String getHtml(CsmObject obj) {
        if (CsmKindUtilities.isOffsetable((Object)obj)) {
            return CsmRefactoringUtils.getHtml((CsmOffsetable)obj);
        }
        if (CsmKindUtilities.isFile((CsmObject)obj)) {
            return CsmDisplayUtilities.htmlize((CharSequence)((Object)((CsmFile)obj).getName()).toString());
        }
        return obj.toString();
    }

    public static CsmFile getCsmFile(CsmObject csmObject) {
        if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            return (CsmFile)csmObject;
        }
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return ((CsmOffsetable)csmObject).getContainingFile();
        }
        return null;
    }

    public static Collection<CsmFunction> getConstructors(CsmClass cls) {
        ArrayList<CsmFunction> out = new ArrayList<CsmFunction>();
        CsmSelect.CsmFilterBuilder filterBuilder = CsmSelect.getFilterBuilder();
        CsmSelect.CsmFilter filter = filterBuilder.createCompoundFilter(filterBuilder.createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION}), filterBuilder.createNameFilter(cls.getName(), true, true, false));
        Iterator classMembers = CsmSelect.getClassMembers((CsmClass)cls, (CsmSelect.CsmFilter)filter);
        while (classMembers.hasNext()) {
            CsmMember csmMember = (CsmMember)classMembers.next();
            if (!CsmKindUtilities.isConstructor((CsmObject)csmMember)) continue;
            out.add((CsmFunction)((CsmConstructor)csmMember));
        }
        return out;
    }

    public static CsmObject getEnclosingElement(CsmObject decl) {
        assert (decl != null);
        if (CsmKindUtilities.isOffsetable((Object)decl)) {
            return CsmRefactoringUtils.findInnerFileObject((CsmOffsetable)decl);
        }
        return null;
    }

    static boolean isLangContainerFeature(CsmObject obj) {
        assert (obj != null);
        return CsmKindUtilities.isFunction((CsmObject)obj) || CsmKindUtilities.isClass((CsmObject)obj) || CsmKindUtilities.isEnum((CsmObject)obj) || CsmKindUtilities.isNamespaceDefinition((CsmObject)obj) || CsmKindUtilities.isFile((CsmObject)obj);
    }

    private static String getHtml(CsmOffsetable obj) {
        CsmFile csmFile = obj.getContainingFile();
        CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
        BaseDocument doc = null;
        String displayText = null;
        if (ces != null && ces.getDocument() instanceof BaseDocument) {
            doc = (BaseDocument)ces.getDocument();
            try {
                int stOffset = obj.getStartOffset();
                int endOffset = obj.getEndOffset();
                int endLineOffset = 1;
                if (CsmKindUtilities.isNamespaceDefinition((CsmObject)obj) || CsmKindUtilities.isEnum((CsmObject)obj)) {
                    endOffset = stOffset;
                    endLineOffset = 0;
                } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)obj)) {
                    endOffset = ((CsmFunctionDefinition)obj).getBody().getStartOffset() - 1;
                } else if (CsmKindUtilities.isClass((CsmObject)obj)) {
                    endOffset = ((CsmClass)obj).getLeftBracketOffset() - 1;
                }
                int startLine = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)stOffset);
                int endLine = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)endOffset) + endLineOffset;
                displayText = CsmDisplayUtilities.getLineHtml((int)startLine, (int)endLine, (int)-1, (int)-1, (BaseDocument)doc);
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
        if (displayText == null) {
            displayText = CsmDisplayUtilities.htmlize((CharSequence)((Object)obj.getText()).toString());
        }
        return displayText;
    }

    private static boolean isInObject(CsmObject obj, int offset) {
        if (!CsmKindUtilities.isOffsetable((Object)obj)) {
            return false;
        }
        CsmOffsetable offs = (CsmOffsetable)obj;
        return offs.getStartOffset() <= offset && offset <= offs.getEndOffset();
    }

    public static boolean isBeforeObject(CsmObject obj, int offset) {
        if (!CsmKindUtilities.isOffsetable((Object)obj)) {
            return false;
        }
        CsmOffsetable offs = (CsmOffsetable)obj;
        return offset < offs.getStartOffset();
    }

    public static CsmObject findInnerFileObject(CsmFile file, int offset) {
        assert (file != null) : "can't be null file in findInnerFileObject";
        CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createOffsetFilter(offset);
        CsmDeclaration lastObject = CsmRefactoringUtils.findInnerDeclaration(CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter), offset);
        return lastObject;
    }

    private static CsmDeclaration findInnerDeclaration(Iterator<? extends CsmDeclaration> it, int offset) {
        CsmDeclaration innerDecl = null;
        if (it != null) {
            while (it.hasNext()) {
                CsmDeclaration decl = it.next();
                assert (decl != null) : "can't be null declaration";
                if (CsmRefactoringUtils.isInObject((CsmObject)decl, offset) && CsmRefactoringUtils.isLangContainerFeature((CsmObject)decl)) {
                    innerDecl = CsmRefactoringUtils.findInnerDeclaration(decl, offset);
                    if (innerDecl != null) {
                        return innerDecl;
                    }
                    return decl;
                }
                if (!CsmRefactoringUtils.isBeforeObject((CsmObject)decl, offset)) continue;
                break;
            }
        }
        return innerDecl;
    }

    private static CsmDeclaration findInnerDeclaration(CsmDeclaration outDecl, int offset) {
        assert (CsmRefactoringUtils.isInObject((CsmObject)outDecl, offset)) : "must be in outDecl object!";
        Iterator it = null;
        if (CsmKindUtilities.isNamespace((Object)outDecl)) {
            CsmNamespace ns = (CsmNamespace)outDecl;
            it = ns.getDeclarations().iterator();
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)outDecl)) {
            it = ((CsmNamespaceDefinition)outDecl).getDeclarations().iterator();
        } else if (CsmKindUtilities.isClass((CsmObject)outDecl)) {
            CsmClass cl = (CsmClass)outDecl;
            it = cl.getMembers().iterator();
        } else if (CsmKindUtilities.isEnum((CsmObject)outDecl)) {
            CsmEnum en = (CsmEnum)outDecl;
            it = en.getEnumerators().iterator();
        }
        return CsmRefactoringUtils.findInnerDeclaration(it, offset);
    }

    private static CsmObject findInnerFileObject(CsmOffsetable csmOffsetable) {
        CsmObject obj;
        CsmFile containingFile = csmOffsetable.getContainingFile();
        if (containingFile != null && (obj = CsmRefactoringUtils.findInnerFileObject(containingFile, csmOffsetable.getStartOffset() - 1)) != null) {
            return obj;
        }
        return containingFile;
    }
}

