/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ThreadsCollector;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.util.WeakListeners;

public class ThreadsCollectorImpl
extends ThreadsCollector {
    private JPDADebuggerImpl debugger;
    private PropertyChangeListener changesInThreadsListener;
    private final Map<JPDAThread, ThreadStateListener> threadStateListeners = new WeakHashMap<JPDAThread, ThreadStateListener>();
    private final List<JPDAThread> threads = new ArrayList<JPDAThread>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadsCollectorImpl(JPDADebuggerImpl jPDADebuggerImpl) {
        this.debugger = jPDADebuggerImpl;
        List<JPDAThread> list = jPDADebuggerImpl.getAllThreads();
        List<JPDAThread> list2 = this.threads;
        synchronized (list2) {
            this.threads.addAll(list);
        }
        this.changesInThreadsListener = new ChangesInThreadsListener();
        jPDADebuggerImpl.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.changesInThreadsListener, (Object)((Object)jPDADebuggerImpl)));
        for (JPDAThread jPDAThread : list) {
            this.watchThread(jPDAThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPDAThread> getAllThreads() {
        List<JPDAThread> list = this.threads;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<JPDAThread>(this.threads));
        }
    }

    public DeadlockDetector getDeadlockDetector() {
        return this.debugger.getDeadlockDetector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchThread(JPDAThread jPDAThread) {
        Map<JPDAThread, ThreadStateListener> map = this.threadStateListeners;
        synchronized (map) {
            if (!this.threadStateListeners.containsKey(jPDAThread)) {
                this.threadStateListeners.put(jPDAThread, new ThreadStateListener(jPDAThread));
            }
        }
    }

    public boolean isSomeThreadRunning() {
        for (JPDAThread jPDAThread : this.getAllThreads()) {
            if (jPDAThread.isSuspended() || ((JPDAThreadImpl)jPDAThread).isMethodInvoking()) continue;
            return true;
        }
        return false;
    }

    public boolean isSomeThreadSuspended() {
        for (JPDAThread jPDAThread : this.getAllThreads()) {
            if (!jPDAThread.isSuspended() && !((JPDAThreadImpl)jPDAThread).isMethodInvoking()) continue;
            return true;
        }
        return false;
    }

    private class ChangesInThreadsListener
    implements PropertyChangeListener {
        private ChangesInThreadsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("threadStarted".equals(string)) {
                JPDAThread jPDAThread = (JPDAThread)propertyChangeEvent.getNewValue();
                ThreadsCollectorImpl.this.watchThread(jPDAThread);
                List list = ThreadsCollectorImpl.this.threads;
                synchronized (list) {
                    if (!ThreadsCollectorImpl.this.threads.contains(jPDAThread)) {
                        ThreadsCollectorImpl.this.threads.add(jPDAThread);
                    }
                }
                ThreadsCollectorImpl.this.firePropertyChange("threadStarted", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else if ("threadDied".equals(string)) {
                JPDAThread jPDAThread = (JPDAThread)propertyChangeEvent.getOldValue();
                List list = ThreadsCollectorImpl.this.threads;
                synchronized (list) {
                    ThreadsCollectorImpl.this.threads.remove(jPDAThread);
                }
                ThreadsCollectorImpl.this.firePropertyChange("threadDied", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else if ("threadGroupAdded".equals(string)) {
                ThreadsCollectorImpl.this.firePropertyChange("threadGroupAdded", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }

    private class ThreadStateListener
    implements PropertyChangeListener {
        public ThreadStateListener(JPDAThread jPDAThread) {
            ((JPDAThreadImpl)jPDAThread).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jPDAThread));
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("suspended".equals(propertyChangeEvent.getPropertyName())) {
                if ("methodInvoke".equals(propertyChangeEvent.getPropagationId())) {
                    return;
                }
                JPDAThread jPDAThread = (JPDAThread)propertyChangeEvent.getSource();
                if (jPDAThread.isSuspended()) {
                    ThreadsCollectorImpl.this.firePropertyChange("threadSuspended", null, jPDAThread);
                } else {
                    ThreadsCollectorImpl.this.firePropertyChange("threadResumed", null, jPDAThread);
                }
            }
        }
    }
}

