/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IntegerValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StringReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.omg.CORBA.portable.ApplicationException;
import org.openide.util.Exceptions;

public class InvocationExceptionTranslated
extends ApplicationException {
    private ObjectReference exeption;
    private JPDADebuggerImpl debugger;
    private String invocationMessage;
    private String message;
    private String localizedMessage;
    private Throwable cause;
    private StackTraceElement[] stackTrace;

    public InvocationExceptionTranslated(InvocationException invocationException, JPDADebuggerImpl jPDADebuggerImpl) {
        this(invocationException.getMessage(), invocationException.exception(), jPDADebuggerImpl);
    }

    private InvocationExceptionTranslated(String string, ObjectReference objectReference, JPDADebuggerImpl jPDADebuggerImpl) {
        super(InvocationException.class.getName(), null);
        this.invocationMessage = string;
        this.exeption = objectReference;
        this.debugger = jPDADebuggerImpl;
    }

    public synchronized String getMessage() {
        block10: {
            if (this.message == null) {
                try {
                    Method method = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(this.exeption), "getMessage", "()Ljava/lang/String;");
                    if (method == null) {
                        this.message = "Unknown exception message";
                        break block10;
                    }
                    try {
                        StringReference stringReference = (StringReference)this.debugger.invokeMethod(this.exeption, method, new Value[0]);
                        this.message = stringReference != null ? StringReferenceWrapper.value(stringReference) : "";
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        return invalidExpressionException.getMessage();
                    }
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    return internalExceptionWrapper.getMessage();
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    return vMDisconnectedExceptionWrapper.getMessage();
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    Exceptions.printStackTrace((Throwable)objectCollectedExceptionWrapper);
                    return objectCollectedExceptionWrapper.getMessage();
                }
                catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
                    return classNotPreparedExceptionWrapper.getMessage();
                }
            }
        }
        if (this.invocationMessage != null) {
            return this.invocationMessage + ": " + this.message;
        }
        return this.message;
    }

    public String getLocalizedMessage() {
        block10: {
            if (this.localizedMessage == null) {
                try {
                    Method method = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(this.exeption), "getLocalizedMessage", "()Ljava/lang/String;");
                    if (method == null) {
                        this.localizedMessage = "Unknown exception message";
                        break block10;
                    }
                    try {
                        StringReference stringReference = (StringReference)this.debugger.invokeMethod(this.exeption, method, new Value[0]);
                        this.localizedMessage = stringReference == null ? "" : StringReferenceWrapper.value(stringReference);
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        return invalidExpressionException.getLocalizedMessage();
                    }
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    return internalExceptionWrapper.getMessage();
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    return vMDisconnectedExceptionWrapper.getMessage();
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    Exceptions.printStackTrace((Throwable)objectCollectedExceptionWrapper);
                    return objectCollectedExceptionWrapper.getMessage();
                }
                catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
                    return classNotPreparedExceptionWrapper.getMessage();
                }
            }
        }
        if (this.invocationMessage != null) {
            return this.invocationMessage + ": " + this.localizedMessage;
        }
        return this.localizedMessage;
    }

    private String getOriginalLocalizedMessage() {
        this.getLocalizedMessage();
        return this.localizedMessage;
    }

    public synchronized Throwable getCause() {
        if (this.cause == null) {
            try {
                Method method = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(this.exeption), "getCause", "()Ljava/lang/Throwable;");
                try {
                    ObjectReference objectReference = method == null ? null : (ObjectReference)this.debugger.invokeMethod(this.exeption, method, new Value[0]);
                    this.cause = objectReference != null ? new InvocationExceptionTranslated(null, objectReference, this.debugger) : this;
                }
                catch (InvalidExpressionException invalidExpressionException) {
                    return null;
                }
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return null;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return null;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                return null;
            }
            catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
                return null;
            }
        }
        return this.cause == this ? null : this.cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            printStream.println((Object)this);
            StackTraceElement[] stackTraceElementArray = this.getOurStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                printStream.println("\tat " + stackTraceElementArray[i]);
            }
            InvocationExceptionTranslated invocationExceptionTranslated = (InvocationExceptionTranslated)((Object)this.getCause());
            if (invocationExceptionTranslated != null) {
                invocationExceptionTranslated.printStackTraceAsCause(printStream, stackTraceElementArray);
            }
        }
    }

    private void printStackTraceAsCause(PrintStream printStream, StackTraceElement[] stackTraceElementArray) {
        InvocationExceptionTranslated invocationExceptionTranslated;
        StackTraceElement[] stackTraceElementArray2 = this.getOurStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        int n2 = stackTraceElementArray2.length - 1 - n;
        printStream.println("Caused by: " + (Object)((Object)this));
        for (int i = 0; i <= n; ++i) {
            printStream.println("\tat " + stackTraceElementArray2[i]);
        }
        if (n2 != 0) {
            printStream.println("\t... " + n2 + " more");
        }
        if ((invocationExceptionTranslated = (InvocationExceptionTranslated)((Object)this.getCause())) != null) {
            invocationExceptionTranslated.printStackTraceAsCause(printStream, stackTraceElementArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println((Object)this);
            StackTraceElement[] stackTraceElementArray = this.getOurStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                printWriter.println("\tat " + stackTraceElementArray[i]);
            }
            InvocationExceptionTranslated invocationExceptionTranslated = (InvocationExceptionTranslated)((Object)this.getCause());
            if (invocationExceptionTranslated != null) {
                invocationExceptionTranslated.printStackTraceAsCause(printWriter, stackTraceElementArray);
            }
        }
    }

    private void printStackTraceAsCause(PrintWriter printWriter, StackTraceElement[] stackTraceElementArray) {
        InvocationExceptionTranslated invocationExceptionTranslated;
        StackTraceElement[] stackTraceElementArray2 = this.getOurStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        int n2 = stackTraceElementArray2.length - 1 - n;
        printWriter.println("Caused by: " + (Object)((Object)this));
        for (int i = 0; i <= n; ++i) {
            printWriter.println("\tat " + stackTraceElementArray2[i]);
        }
        if (n2 != 0) {
            printWriter.println("\t... " + n2 + " more");
        }
        if ((invocationExceptionTranslated = (InvocationExceptionTranslated)((Object)this.getCause())) != null) {
            invocationExceptionTranslated.printStackTraceAsCause(printWriter, stackTraceElementArray2);
        }
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getOurStackTrace().clone();
    }

    private synchronized StackTraceElement[] getOurStackTrace() {
        if (this.stackTrace == null) {
            try {
                Method method = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(this.exeption), "getStackTrace", "()[Ljava/lang/StackTraceElement;");
                if (method == null) {
                    return new StackTraceElement[0];
                }
                ArrayReference arrayReference = (ArrayReference)this.debugger.invokeMethod(this.exeption, method, new Value[0]);
                int n = ArrayReferenceWrapper.length(arrayReference);
                this.stackTrace = new StackTraceElement[n];
                for (int i = 0; i < n; ++i) {
                    this.stackTrace[i] = this.getStackTraceElement((ObjectReference)ArrayReferenceWrapper.getValue(arrayReference, i));
                }
            }
            catch (InvalidExpressionException invalidExpressionException) {
                return new StackTraceElement[0];
            }
            catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
                return new StackTraceElement[0];
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return new StackTraceElement[0];
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return new StackTraceElement[0];
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                return new StackTraceElement[0];
            }
        }
        return this.stackTrace;
    }

    private StackTraceElement getStackTraceElement(ObjectReference objectReference) {
        try {
            int n;
            String string;
            String string2;
            Value value;
            String string3;
            Method method = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(objectReference), "getClassName", "()Ljava/lang/String;");
            if (method == null) {
                string3 = "unknown";
            } else {
                try {
                    value = (StringReference)this.debugger.invokeMethod(objectReference, method, new Value[0]);
                    string3 = StringReferenceWrapper.value(value);
                }
                catch (InvalidExpressionException invalidExpressionException) {
                    string3 = invalidExpressionException.getLocalizedMessage();
                }
            }
            method = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(objectReference), "getMethodName", "()Ljava/lang/String;");
            if (method == null) {
                string2 = "unknown";
            } else {
                try {
                    value = (StringReference)this.debugger.invokeMethod(objectReference, method, new Value[0]);
                    string2 = StringReferenceWrapper.value(value);
                }
                catch (InvalidExpressionException invalidExpressionException) {
                    string2 = invalidExpressionException.getLocalizedMessage();
                }
            }
            method = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(objectReference), "getFileName", "()Ljava/lang/String;");
            if (method == null) {
                string = "unknown";
            } else {
                try {
                    value = (StringReference)this.debugger.invokeMethod(objectReference, method, new Value[0]);
                    string = value == null ? null : StringReferenceWrapper.value(value);
                }
                catch (InvalidExpressionException invalidExpressionException) {
                    string = invalidExpressionException.getLocalizedMessage();
                }
            }
            method = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(objectReference), "getLineNumber", "()I");
            if (method == null) {
                n = -1;
            } else {
                try {
                    value = (IntegerValue)this.debugger.invokeMethod(objectReference, method, new Value[0]);
                    n = IntegerValueWrapper.value((IntegerValue)value);
                }
                catch (InvalidExpressionException invalidExpressionException) {
                    n = -1;
                }
            }
            return new StackTraceElement(string3, string2, string, n);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            String string = internalExceptionWrapper.getLocalizedMessage();
            return new StackTraceElement(string, string, string, -1);
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            String string = vMDisconnectedExceptionWrapper.getLocalizedMessage();
            return new StackTraceElement(string, string, string, -1);
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            Exceptions.printStackTrace((Throwable)objectCollectedExceptionWrapper);
            String string = objectCollectedExceptionWrapper.getLocalizedMessage();
            return new StackTraceElement(string, string, string, -1);
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
            String string = classNotPreparedExceptionWrapper.getLocalizedMessage();
            return new StackTraceElement(string, string, string, -1);
        }
    }

    public String toString() {
        String string;
        try {
            string = TypeWrapper.name(ValueWrapper.type(this.exeption));
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return "Collected";
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "Disconnected";
        }
        String string2 = this.getOriginalLocalizedMessage();
        return string2 != null ? string + ": " + string2 : string;
    }
}

