/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import org.netbeans.api.debugger.jpda.ReturnVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;

public class ReturnVariableImpl
extends AbstractObjectVariable
implements ReturnVariable {
    private String methodName;

    public ReturnVariableImpl(JPDADebuggerImpl jPDADebuggerImpl, Value value, String string, String string2) {
        super(jPDADebuggerImpl, value, string + ".return " + string2 + "=" + ReturnVariableImpl.getStringValue(value));
        this.methodName = string2;
    }

    private static String getStringValue(Value value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof VoidValue) {
            return "void";
        }
        if (value instanceof PrimitiveValue) {
            return value.toString();
        }
        try {
            return "#" + ObjectReferenceWrapper.uniqueID((ObjectReference)value);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return "#" + internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "#0";
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return "#0";
        }
    }

    public String methodName() {
        return this.methodName;
    }

    @Override
    public ReturnVariableImpl clone() {
        return new ReturnVariableImpl(this.getDebugger(), this.getJDIValue(), this.getID().substring(0, this.getID().length() - ".return".length()), this.methodName);
    }

    @Override
    public String toString() {
        return "ReturnVariable " + this.getValue();
    }
}

