/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class JTitledPanel
extends JPanel {
    private static final ImageIcon closePanelIcon = new ImageIcon(JTitledPanel.class.getResource("/org/netbeans/lib/profiler/ui/resources/closePanel.png"));
    private static final ImageIcon maximizePanelIcon = new ImageIcon(JTitledPanel.class.getResource("/org/netbeans/lib/profiler/ui/resources/maximizePanel.png"));
    private static final ImageIcon restorePanelIcon = new ImageIcon(JTitledPanel.class.getResource("/org/netbeans/lib/profiler/ui/resources/restorePanel.png"));
    private static final ImageIcon minimizePanelIcon = new ImageIcon(JTitledPanel.class.getResource("/org/netbeans/lib/profiler/ui/resources/minimizePanel.png"));
    public static final int STATE_CLOSED = 1000;
    public static final int STATE_RESTORED = 1001;
    public static final int STATE_MAXIMIZED = 1002;
    public static final int STATE_MINIMIZED = 1003;
    private AbstractButton presenter;
    private Icon icon;
    private JButton closePanelButton;
    private JButton maximizePanelButton;
    private JButton minimizePanelButton;
    private JButton restorePanelButton;
    private JPanel contentPanel;
    private JPanel titlePanel;
    private String title;
    private Vector actionListeners = new Vector();
    private boolean showButtons;
    private int state;

    public JTitledPanel(String title) {
        this(title, null);
    }

    public JTitledPanel(String title, Icon icon) {
        this(title, icon, false);
    }

    public JTitledPanel(String title, Icon icon, boolean showButtons) {
        this.title = title;
        this.icon = icon;
        this.showButtons = showButtons;
        this.initComponents();
        this.restore();
    }

    public void setButtonsEnabled(boolean enabled) {
        this.closePanelButton.setEnabled(enabled);
        this.maximizePanelButton.setEnabled(enabled);
        this.restorePanelButton.setEnabled(enabled);
        this.minimizePanelButton.setEnabled(enabled);
    }

    public boolean isClosed() {
        return this.getState() == 1000;
    }

    public JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
        }
        return this.contentPanel;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        this.getContentPanel().setLayout(mgr);
    }

    @Override
    public LayoutManager getLayout() {
        return this.getContentPanel().getLayout();
    }

    public boolean isMaximized() {
        return this.getState() == 1002;
    }

    public boolean isMinimized() {
        return this.getState() == 1003;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, this.titlePanel.getPreferredSize().height);
    }

    public AbstractButton getPresenter() {
        if (this.presenter == null) {
            this.presenter = new Presenter();
        }
        return this.presenter;
    }

    public boolean isRestored() {
        return this.getState() == 1001;
    }

    public int getState() {
        if (!this.isVisible()) {
            this.state = 1000;
        }
        if (this.isVisible() && this.state == 1000) {
            this.state = 1001;
        }
        return this.state;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public Component add(Component comp) {
        return this.getContentPanel().add(comp);
    }

    @Override
    public Component add(Component comp, int index) {
        return this.getContentPanel().add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.getContentPanel().add(comp, constraints);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.getContentPanel().add(comp, constraints, index);
    }

    @Override
    public Component add(String name, Component comp) {
        return this.getContentPanel().add(name, comp);
    }

    @Override
    public void add(PopupMenu popup) {
        this.getContentPanel().add(popup);
    }

    public void addActionListener(ActionListener listener) {
        if (!this.actionListeners.contains(listener)) {
            this.actionListeners.add(listener);
        }
    }

    public boolean areButtonsEnabled() {
        return this.closePanelButton.isEnabled();
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.setVisible(false);
        this.state = 1000;
        this.fireActionPerformed();
    }

    public void maximize() {
        if (this.isMaximized()) {
            return;
        }
        this.maximizePanelButton.setVisible(false);
        this.restorePanelButton.setVisible(true);
        this.minimizePanelButton.setVisible(true);
        this.contentPanel.setVisible(true);
        this.state = 1002;
        this.fireActionPerformed();
    }

    public void minimize() {
        if (this.isMinimized()) {
            return;
        }
        this.maximizePanelButton.setVisible(true);
        this.restorePanelButton.setVisible(true);
        this.minimizePanelButton.setVisible(false);
        this.contentPanel.setVisible(false);
        this.state = 1003;
        this.fireActionPerformed();
    }

    @Override
    public void remove(Component component) {
        this.getContentPanel().remove(component);
    }

    @Override
    public void remove(MenuComponent component) {
        this.getContentPanel().remove(component);
    }

    @Override
    public void remove(int index) {
        this.getContentPanel().remove(index);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    @Override
    public void removeAll() {
        this.getContentPanel().removeAll();
    }

    public void restore() {
        if (this.isRestored()) {
            return;
        }
        this.maximizePanelButton.setVisible(true);
        this.restorePanelButton.setVisible(false);
        this.minimizePanelButton.setVisible(true);
        this.contentPanel.setVisible(true);
        this.state = 1001;
        this.fireActionPerformed();
    }

    protected Color getTitleBorderColor() {
        return UIManager.getLookAndFeel().getID().equals("Metal") ? UIManager.getColor("Button.darkShadow") : UIManager.getColor("Button.shadow");
    }

    private void fireActionPerformed() {
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            ((ActionListener)this.actionListeners.get(i)).actionPerformed(new ActionEvent(this, this.getState(), ""));
        }
    }

    private void initComponents() {
        DoubleClickListener dblClickListener = new DoubleClickListener();
        this.titlePanel = new JPanel();
        this.titlePanel.addMouseListener(dblClickListener);
        super.setLayout(new BorderLayout());
        JLabel titleLabel = new JLabel(this.title){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(0, super.getMinimumSize().height);
            }
        };
        if (this.icon != null) {
            titleLabel.setIcon(this.icon);
        }
        titleLabel.setForeground(UIManager.getColor("ToolTip.foreground"));
        titleLabel.setFont(UIManager.getFont("ToolTip.font"));
        titleLabel.setOpaque(false);
        titleLabel.addMouseListener(dblClickListener);
        this.closePanelButton = new ImageIconButton(closePanelIcon);
        this.closePanelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTitledPanel.this.close();
            }
        });
        this.maximizePanelButton = new ImageIconButton(maximizePanelIcon);
        this.maximizePanelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTitledPanel.this.maximize();
            }
        });
        this.restorePanelButton = new ImageIconButton(restorePanelIcon);
        this.restorePanelButton.setVisible(false);
        this.restorePanelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTitledPanel.this.restore();
            }
        });
        this.minimizePanelButton = new ImageIconButton(minimizePanelIcon);
        this.minimizePanelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTitledPanel.this.minimize();
            }
        });
        JPanel buttonsContainer = new JPanel(new FlowLayout(4, 0, 0));
        buttonsContainer.setOpaque(false);
        buttonsContainer.add(this.closePanelButton);
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.setOpaque(false);
        buttonsPanel.add((Component)buttonsContainer, new GridBagConstraints());
        this.titlePanel.setLayout(new BorderLayout());
        this.titlePanel.add((Component)titleLabel, "West");
        if (this.showButtons) {
            this.titlePanel.add((Component)buttonsPanel, "East");
        }
        this.titlePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.getTitleBorderColor()), BorderFactory.createEmptyBorder(2, 5, 2, 2)));
        this.titlePanel.setOpaque(true);
        this.titlePanel.setBackground(new Color(245, 245, 245));
        super.add((Component)this.titlePanel, "North");
        super.add((Component)this.contentPanel, "Center");
    }

    private class Presenter
    extends JToggleButton {
        public Presenter() {
            if (JTitledPanel.this.getIcon() == null) {
                this.setText(JTitledPanel.this.getTitle());
                this.setToolTipText(JTitledPanel.this.getTitle());
            } else {
                this.setIcon(JTitledPanel.this.getIcon());
                this.setToolTipText(JTitledPanel.this.getTitle());
            }
            this.setSelected(JTitledPanel.this.isVisible());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTitledPanel.this.setVisible(Presenter.this.isSelected());
                }
            });
            JTitledPanel.this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    Presenter.this.setSelected(true);
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    Presenter.this.setSelected(false);
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("enabled".equals(evt.getPropertyName())) {
                        JTitledPanel.this.setButtonsEnabled(Presenter.this.isEnabled());
                    }
                }
            });
        }
    }

    private class ImageIconButton
    extends JButton
    implements MouseListener {
        private Border emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private Border loweredBorder = new ThinBevelBorder(1, Color.WHITE, Color.GRAY);
        private Border raisedBorder = new ThinBevelBorder(0, Color.WHITE, Color.GRAY);
        private boolean focused = false;
        private boolean pressed = false;

        public ImageIconButton(ImageIcon icon) {
            GrayFilter enabledFilter = new GrayFilter(true, 35);
            FilteredImageSource prod = new FilteredImageSource(icon.getImage().getSource(), enabledFilter);
            ImageIcon grayIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(prod));
            GrayFilter disabledFilter = new GrayFilter(true, 60);
            prod = new FilteredImageSource(icon.getImage().getSource(), disabledFilter);
            ImageIcon disabledIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(prod));
            this.setIcon(grayIcon);
            this.setRolloverIcon(icon);
            this.setPressedIcon(icon);
            this.setDisabledIcon(disabledIcon);
            this.setIconTextGap(0);
            this.setBorder(this.emptyBorder);
            this.setFocusable(false);
            this.setContentAreaFilled(false);
            this.setPreferredSize(new Dimension(icon.getIconWidth() + 8, icon.getIconHeight() + 8));
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.focused = true;
            if (this.pressed) {
                this.setBorder(this.loweredBorder);
            } else {
                this.setBorder(this.raisedBorder);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.focused = false;
            this.setBorder(this.emptyBorder);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.pressed = true;
            this.setBorder(this.loweredBorder);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.pressed = false;
            if (this.focused) {
                this.setBorder(this.raisedBorder);
            } else {
                this.setBorder(this.emptyBorder);
            }
        }
    }

    private class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getModifiers() == 16 && e.getClickCount() == 2) {
                if (JTitledPanel.this.isMaximized()) {
                    JTitledPanel.this.restore();
                } else {
                    JTitledPanel.this.maximize();
                }
            }
        }
    }

    private static class ThinBevelBorder
    extends BevelBorder {
        public ThinBevelBorder(int bevelType, Color highlight, Color shadow) {
            super(bevelType, highlight.brighter(), highlight, shadow, shadow.brighter());
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = 1;
            insets.right = 1;
            insets.top = 1;
            insets.left = 1;
            return insets;
        }

        @Override
        protected void paintLoweredBevel(Component c, Graphics g, int x, int y, int width, int height) {
            if (!c.isEnabled()) {
                return;
            }
            Color oldColor = g.getColor();
            int h = height;
            int w = width;
            g.translate(x, y);
            g.setColor(this.getShadowOuterColor(c));
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(1, 0, w - 1, 0);
            g.setColor(this.getHighlightInnerColor(c));
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }

        @Override
        protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height) {
            if (!c.isEnabled()) {
                return;
            }
            Color oldColor = g.getColor();
            int h = height;
            int w = width;
            g.translate(x, y);
            g.setColor(this.getHighlightInnerColor(c));
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(1, 0, w - 1, 0);
            g.setColor(this.getShadowOuterColor(c));
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 0, w - 1, h - 2);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }
}

