/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import javax.swing.AbstractButton;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.AbstractTopLevelController;
import org.netbeans.modules.profiler.heapwalk.ClassesListController;
import org.netbeans.modules.profiler.heapwalk.FieldsBrowserController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.NavigationHistoryManager;
import org.netbeans.modules.profiler.heapwalk.ui.ClassesControllerUI;

public class ClassesController
extends AbstractTopLevelController
implements FieldsBrowserController.Handler,
NavigationHistoryManager.NavigationHistoryCapable {
    private ClassesListController classesListController;
    private FieldsBrowserController staticFieldsBrowserController;
    private HeapFragmentWalker heapFragmentWalker;

    public ClassesController(HeapFragmentWalker heapFragmentWalker) {
        this.heapFragmentWalker = heapFragmentWalker;
        this.classesListController = new ClassesListController(this);
        this.staticFieldsBrowserController = new FieldsBrowserController(this, 1);
    }

    public ClassesListController getClassesListController() {
        return this.classesListController;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        long l = -1L;
        JavaClass javaClass = this.getSelectedClass();
        if (javaClass != null) {
            l = javaClass.getJavaClassId();
        }
        return new Configuration(l);
    }

    @Override
    public HeapFragmentWalker getHeapFragmentWalker() {
        return this.heapFragmentWalker;
    }

    public JavaClass getSelectedClass() {
        return this.classesListController.getSelectedClass();
    }

    public FieldsBrowserController getStaticFieldsBrowserController() {
        return this.staticFieldsBrowserController;
    }

    public void classSelected() {
        JavaClass javaClass = this.getSelectedClass();
        this.staticFieldsBrowserController.setJavaClass(javaClass);
    }

    @Override
    public void configure(NavigationHistoryManager.Configuration configuration) {
        if (configuration instanceof Configuration) {
            Configuration configuration2 = (Configuration)configuration;
            this.heapFragmentWalker.switchToHistoryClassesView();
            JavaClass javaClass = null;
            long l = configuration2.getJavaClassID();
            if (l != -1L) {
                javaClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByID(l);
            }
            if (javaClass != null) {
                this.classesListController.selectClass(javaClass);
            }
        } else {
            throw new IllegalArgumentException("Unsupported configuration: " + configuration);
        }
    }

    @Override
    public void showClass(JavaClass javaClass) {
        this.heapFragmentWalker.switchToClassesView();
        if (!this.classesListController.getPanel().isVisible()) {
            this.classesListController.getPanel().setVisible(true);
        }
        this.classesListController.selectClass(javaClass);
    }

    @Override
    public void showInstance(Instance instance) {
        this.heapFragmentWalker.getInstancesController().showInstance(instance);
    }

    @Override
    protected AbstractButton[] createClientPresenters() {
        return new AbstractButton[]{this.classesListController.getPresenter(), this.staticFieldsBrowserController.getPresenter()};
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((ClassesControllerUI)this.getPanel()).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new ClassesControllerUI(this);
    }

    public static class Configuration
    extends NavigationHistoryManager.Configuration {
        private long javaClassID;

        public Configuration(long l) {
            this.javaClassID = l;
        }

        public long getJavaClassID() {
            return this.javaClassID;
        }
    }
}

