/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ResetResultsProfilingPoint;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.ResetResultsCustomizer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ResetResultsProfilingPointFactory
extends CodeProfilingPointFactory {
    private static final String PP_TYPE = NbBundle.getMessage(ResetResultsProfilingPointFactory.class, (String)"ResetResultsProfilingPointFactory_PpType");
    private static final String PP_DESCR = NbBundle.getMessage(ResetResultsProfilingPointFactory.class, (String)"ResetResultsProfilingPointFactory_PpDescr");
    private static final String PP_DEFAULT_NAME = NbBundle.getMessage(ResetResultsProfilingPointFactory.class, (String)"ResetResultsProfilingPointFactory_PpDefaultName");
    public static final Icon RESET_RESULTS_PP_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/ppoints/ui/resources/resetResultsProfilingPoint.png", (boolean)false);
    public static final String RESET_RESULTS_PP_TYPE = PP_TYPE;
    public static final String RESET_RESULTS_PP_DESCR = PP_DESCR;

    @Override
    public String getDescription() {
        return RESET_RESULTS_PP_DESCR;
    }

    @Override
    public Icon getIcon() {
        return RESET_RESULTS_PP_ICON;
    }

    @Override
    public int getScope() {
        return 1;
    }

    @Override
    public String getType() {
        return RESET_RESULTS_PP_TYPE;
    }

    @Override
    public ResetResultsProfilingPoint create(Project project) {
        CodeProfilingPoint.Location location;
        if (project == null) {
            project = Utils.getCurrentProject();
        }
        if ((location = Utils.getCurrentLocation(Integer.MIN_VALUE)).equals(CodeProfilingPoint.Location.EMPTY)) {
            String string = "";
            String string2 = Utils.getUniqueName(this.getType(), "", project);
            return new ResetResultsProfilingPoint(string2, location, project, this);
        }
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        String string = FileUtil.toFileObject((File)file).getName();
        String string3 = Utils.getUniqueName(this.getType(), MessageFormat.format(PP_DEFAULT_NAME, "", string, location.getLine()), project);
        return new ResetResultsProfilingPoint(string3, location, project, this);
    }

    @Override
    public boolean supportsCPU() {
        return true;
    }

    @Override
    public boolean supportsMemory() {
        return true;
    }

    @Override
    public boolean supportsMonitor() {
        return false;
    }

    @Override
    protected Class getProfilingPointsClass() {
        return ResetResultsProfilingPoint.class;
    }

    @Override
    protected String getServerHandlerClassName() {
        return "org.netbeans.lib.profiler.server.ResetResultsProfilingPointHandler";
    }

    @Override
    protected ResetResultsCustomizer createCustomizer() {
        return new ResetResultsCustomizer(this.getType(), this.getIcon());
    }

    @Override
    protected ProfilingPoint loadProfilingPoint(Project project, Properties properties, int n) {
        String string = properties.getProperty(n + "_" + "p_name", null);
        String string2 = properties.getProperty(n + "_" + "p_enabled", null);
        CodeProfilingPoint.Location location = CodeProfilingPoint.Location.load(project, n, properties);
        if (string == null || string2 == null || location == null) {
            return null;
        }
        ResetResultsProfilingPoint resetResultsProfilingPoint = null;
        try {
            resetResultsProfilingPoint = new ResetResultsProfilingPoint(string, location, project, this);
            resetResultsProfilingPoint.setEnabled(Boolean.parseBoolean(string2));
        }
        catch (Exception exception) {
            ErrorManager.getDefault().log(65536, exception.getMessage());
        }
        return resetResultsProfilingPoint;
    }

    @Override
    protected void storeProfilingPoint(ProfilingPoint profilingPoint, int n, Properties properties) {
        ResetResultsProfilingPoint resetResultsProfilingPoint = (ResetResultsProfilingPoint)profilingPoint;
        properties.put(n + "_" + "p_name", resetResultsProfilingPoint.getName());
        properties.put(n + "_" + "p_enabled", Boolean.toString(resetResultsProfilingPoint.isEnabled()));
        resetResultsProfilingPoint.getLocation().store(resetResultsProfilingPoint.getProject(), n, properties);
    }
}

