/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.items.form;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.items.form.SVGFormElement;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;

public class RadioButton
extends SVGFormElement {
    private static final String ID_PATTERN_FRAME = "%%FRAME_COMPONENT_ID%%";
    private static final String ID_PATTERN_1 = "%%COMPONENT_ID_1%%";
    private static final String ID_PATTERN_2 = "%%COMPONENT_ID_2%%";
    private static final String SNIPPET_PATH = "radiobutton_snippet.xml_template";

    public RadioButton() {
        super(SNIPPET_PATH);
    }

    @Override
    protected boolean doTransfer(SVGDataObject svgDataObject) {
        SVGFileModel model = svgDataObject.getModel();
        try {
            String idFrame = model.createUniqueId("radiobuttonframe", false);
            String id1 = model.createUniqueId("radiobutton", false);
            String id2 = model.createUniqueId("radiobutton", false, new HashSet<String>(Arrays.asList(id1)));
            String snippet = this.getSnippet(idFrame, id1, id2);
            model.mergeImage(snippet, false);
            this.setSelection(idFrame);
            return true;
        }
        catch (Exception ex) {
            SceneManager.error("Error during image merge", ex);
            return false;
        }
    }

    @Override
    protected boolean doTransfer(JTextComponent target) {
        SVGDataObject svgDataObject = SVGDataObject.getActiveDataObject(target);
        SVGFileModel model = svgDataObject.getModel();
        try {
            String idFrame = model.createUniqueId("radiobuttonframe", false);
            String id1 = model.createUniqueId("radiobutton", false);
            String id2 = model.createUniqueId("radiobutton", false, new HashSet<String>(Arrays.asList(id1)));
            String snippet = this.getSnippet(idFrame, id1, id2);
            RadioButton.insertToTextComponent(snippet, target);
            return true;
        }
        catch (Exception ex) {
            SceneManager.error("Error during image merge", ex);
            return false;
        }
    }

    private String getSnippet(String idFrame, String id1, String id2) throws IOException {
        String text = this.loadSnippetString();
        String withIdFrame = text.replace(ID_PATTERN_FRAME, idFrame);
        String withId1 = withIdFrame.replace(ID_PATTERN_1, id1);
        String withId2 = withId1.replace(ID_PATTERN_2, id2);
        return this.replaceCoordinates(withId2);
    }
}

