/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class ClassPathModifierSupport {
    public static final int ADD = 1;
    public static final int ADD_NO_HEURISTICS = 3;
    public static final int REMOVE = 2;
    private static final Logger LOG = Logger.getLogger(ClassPathModifierSupport.class.getName());

    public static boolean handleRoots(final Project project, final AntProjectHelper helper, final ClassPathSupport cs, final PropertyEvaluator eval, final ClassPathUiSupport.Callback cpUiSupportCallback, final URI[] classPathRoots, final String classPathProperty, final String projectXMLElementName, final int operation) throws IOException {
        assert (classPathRoots != null) : "The classPathRoots cannot be null";
        assert (classPathProperty != null);
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws Exception {
                    EditableProperties props = helper.getProperties("nbproject/project.properties");
                    String raw = props.getProperty(classPathProperty);
                    List<ClassPathSupport.Item> resources = cs.itemsList(raw, projectXMLElementName);
                    boolean changed = false;
                    File projectFolderFile = FileUtil.toFile((FileObject)helper.getProjectDirectory());
                    for (int i = 0; i < classPathRoots.length; ++i) {
                        String filePath;
                        if (3 == operation || 2 == operation || !classPathRoots[i].isAbsolute()) {
                            URI toAdd = LibrariesSupport.getArchiveFile((URI)classPathRoots[i]);
                            if (toAdd == null) {
                                toAdd = classPathRoots[i];
                            }
                            filePath = LibrariesSupport.convertURIToFilePath((URI)toAdd);
                        } else {
                            filePath = Accessor.performHeuristics(classPathRoots[i], helper);
                        }
                        String filePath2 = filePath;
                        if (filePath2.startsWith("${var.")) {
                            filePath2 = eval.evaluate(filePath);
                        }
                        ClassPathSupport.Item item = ClassPathSupport.Item.create(filePath2, projectFolderFile, null, filePath.startsWith("${var.") ? filePath : null);
                        if (cpUiSupportCallback != null) {
                            cpUiSupportCallback.initItem(item);
                        }
                        if (!(operation != 1 && operation != 3 || resources.contains(item))) {
                            resources.add(item);
                            changed = true;
                            continue;
                        }
                        if (operation != 2) continue;
                        if (resources.remove(item)) {
                            changed = true;
                            continue;
                        }
                        Iterator<ClassPathSupport.Item> it = resources.iterator();
                        while (it.hasNext()) {
                            ClassPathSupport.Item resource = it.next();
                            if (!resource.isBroken() || resource.getType() != 0 || !filePath.equals(resource.getFilePath()) && !filePath.equals(resource.getVariableBasedProperty())) continue;
                            it.remove();
                            changed = true;
                        }
                    }
                    if (changed) {
                        String[] itemRefs = cs.encodeToStrings(resources, projectXMLElementName);
                        props = helper.getProperties("nbproject/project.properties");
                        props.setProperty(classPathProperty, itemRefs);
                        helper.putProperties("nbproject/project.properties", props);
                        ProjectManager.getDefault().saveProject(project);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException t = new IOException();
            t.initCause(e);
            throw t;
        }
    }

    public static boolean handleAntArtifacts(final Project project, final AntProjectHelper helper, final ClassPathSupport cs, PropertyEvaluator eval, final ClassPathUiSupport.Callback cpUiSupportCallback, final AntArtifact[] artifacts, final URI[] artifactElements, final String classPathProperty, final String projectXMLElementName, final int operation) throws IOException, UnsupportedOperationException {
        assert (artifacts != null) : "Artifacts cannot be null";
        assert (artifactElements != null) : "ArtifactElements cannot be null";
        assert (artifacts.length == artifactElements.length) : "Each artifact has to have corresponding artifactElement";
        assert (classPathProperty != null);
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws Exception {
                    EditableProperties props = helper.getProperties("nbproject/project.properties");
                    String raw = props.getProperty(classPathProperty);
                    List<ClassPathSupport.Item> resources = cs.itemsList(raw, projectXMLElementName);
                    boolean changed = false;
                    for (int i = 0; i < artifacts.length; ++i) {
                        assert (artifacts[i] != null);
                        assert (artifactElements[i] != null);
                        ClassPathSupport.Item item = ClassPathSupport.Item.create(artifacts[i], artifactElements[i], null);
                        if (cpUiSupportCallback != null) {
                            cpUiSupportCallback.initItem(item);
                        }
                        if (operation == 1 && !resources.contains(item)) {
                            resources.add(item);
                            changed = true;
                            continue;
                        }
                        if (operation != 2 || !resources.contains(item)) continue;
                        resources.remove(item);
                        changed = true;
                    }
                    if (changed) {
                        String[] itemRefs = cs.encodeToStrings(resources, projectXMLElementName);
                        props = helper.getProperties("nbproject/project.properties");
                        props.setProperty(classPathProperty, itemRefs);
                        helper.putProperties("nbproject/project.properties", props);
                        ProjectManager.getDefault().saveProject(project);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException t = new IOException();
            t.initCause(e);
            throw t;
        }
    }

    public static boolean handleLibraries(Project project, AntProjectHelper helper, ClassPathSupport cs, PropertyEvaluator eval, ClassPathUiSupport.Callback cpUiSupportCallback, ReferenceHelper refHelper, Library[] libraries, String classPathProperty, String projectXMLElementName, int operation) throws IOException, UnsupportedOperationException {
        ArrayList<ClassPathSupport.Item> items = new ArrayList<ClassPathSupport.Item>(libraries.length);
        for (int i = 0; i < libraries.length; ++i) {
            Library lib = ClassPathModifierSupport.checkLibrarySharability(project, helper, refHelper, libraries[i]);
            ClassPathSupport.Item item = ClassPathSupport.Item.create(lib, null);
            if (cpUiSupportCallback != null) {
                cpUiSupportCallback.initItem(item);
            }
            items.add(item);
        }
        return ClassPathModifierSupport.handleLibraryClassPathItems(project, helper, cs, items, classPathProperty, projectXMLElementName, operation, true);
    }

    private static Library checkLibrarySharability(Project project, AntProjectHelper antHelper, ReferenceHelper refHelper, Library lib) throws IOException {
        if (antHelper.isSharableProject()) {
            if (lib.getManager().getLocation() == null) {
                LOG.log(Level.FINE, "Client is adding global library [" + lib + "] to sharable project.", new Exception());
                Library l = refHelper.getProjectLibraryManager().getLibrary(lib.getName());
                lib = l != null ? l : refHelper.copyLibrary(lib);
            } else if (!lib.getManager().getLocation().equals(refHelper.getProjectLibraryManager().getLocation())) {
                throw new UnsupportedOperationException("Adding library '" + lib.getName() + "' from '" + lib.getManager().getLocation() + "' to project '" + project.getProjectDirectory() + "' is not supported because project libraries are defined in '" + refHelper.getProjectLibraryManager().getLocation() + "'");
            }
        }
        return lib;
    }

    public static boolean handleLibraryClassPathItems(final Project project, final AntProjectHelper helper, final ClassPathSupport cs, final List<ClassPathSupport.Item> items, final String classPathProperty, final String projectXMLElementName, final int operation, final boolean saveProject) throws IOException {
        assert (items != null) : "Libraries cannot be null";
        assert (classPathProperty != null);
        assert (saveProject || ProjectManager.mutex().isWriteAccess());
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    EditableProperties props = helper.getProperties("nbproject/project.properties");
                    String raw = props.getProperty(classPathProperty);
                    List<ClassPathSupport.Item> resources = cs.itemsList(raw, projectXMLElementName);
                    ArrayList<ClassPathSupport.Item> changed = new ArrayList<ClassPathSupport.Item>(items.size());
                    for (ClassPathSupport.Item item : items) {
                        assert (item != null);
                        assert (item.getType() == 1);
                        if (operation == 1 && !resources.contains(item)) {
                            resources.add(item);
                            changed.add(item);
                            continue;
                        }
                        if (operation != 2 || !resources.contains(item)) continue;
                        resources.remove(item);
                        changed.add(item);
                    }
                    if (!changed.isEmpty()) {
                        String[] itemRefs = cs.encodeToStrings(resources, projectXMLElementName);
                        props = helper.getProperties("nbproject/project.properties");
                        props.setProperty(classPathProperty, itemRefs);
                        helper.putProperties("nbproject/project.properties", props);
                        if (saveProject) {
                            ProjectManager.getDefault().saveProject(project);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private static class Accessor
    extends ProjectClassPathModifierImplementation {
        private Accessor() {
        }

        public static String performHeuristics(URI classpathRoot, AntProjectHelper helper) throws URISyntaxException, IOException {
            Accessor i = new Accessor();
            return i.performSharabilityHeuristics(classpathRoot, helper);
        }

        protected SourceGroup[] getExtensibleSourceGroups() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected String[] getExtensibleClassPathTypes(SourceGroup sourceGroup) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected boolean addLibraries(Library[] libraries, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected boolean removeLibraries(Library[] libraries, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected boolean addRoots(URL[] classPathRoots, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected boolean removeRoots(URL[] classPathRoots, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected boolean addAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected boolean removeAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

