/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.UnknownServiceException;
import org.netbeans.core.startup.layers.NbinstURLMapper;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class NbinstURLStreamHandler
extends URLStreamHandler {
    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        return new NbinstURLConnection(u);
    }

    private static class NbinstURLConnection
    extends URLConnection {
        private FileObject fo;
        private InputStream iStream;

        public NbinstURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
            if (this.fo == null) {
                FileObject[] decoded = NbinstURLMapper.decodeURL(this.url);
                if (decoded != null && decoded.length > 0) {
                    this.fo = decoded[0];
                } else {
                    throw new FileNotFoundException("Cannot find: " + this.url);
                }
            }
            if (this.fo.isFolder()) {
                throw new UnknownServiceException();
            }
        }

        @Override
        public int getContentLength() {
            try {
                this.connect();
                return (int)this.fo.getSize();
            }
            catch (IOException e) {
                return -1;
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            if (this.iStream == null) {
                this.iStream = this.fo.getInputStream();
            }
            return this.iStream;
        }

        @Override
        public String getHeaderField(String name) {
            if ("content-type".equals(name)) {
                try {
                    this.connect();
                    return this.fo.getMIMEType();
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
            return super.getHeaderField(name);
        }
    }
}

