/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.driver.JDBCDriverSupport;
import org.netbeans.modules.db.util.DataComboBoxModel;
import org.netbeans.modules.db.util.DataComboBoxSupport;
import org.netbeans.modules.db.util.DriverListUtil;
import org.netbeans.modules.db.util.JdbcUrl;
import org.openide.util.NbBundle;

public final class DatabaseExplorerInternalUIs {
    private DatabaseExplorerInternalUIs() {
    }

    public static void connect(JComboBox comboBox, JDBCDriverManager driverManager) {
        DatabaseExplorerInternalUIs.connect(comboBox, driverManager, null);
    }

    public static void connect(JComboBox comboBox, JDBCDriverManager driverManager, String driverClass) {
        DataComboBoxSupport.connect(comboBox, new DriverDataComboBoxModel(driverManager, driverClass), driverClass == null);
    }

    private static final class DriverTypeComparator
    implements Comparator {
        private DriverTypeComparator() {
        }

        public int compare(Object type1, Object type2) {
            if (type1 == null) {
                return type2 == null ? 0 : -1;
            }
            if (type2 == null) {
                return 1;
            }
            String dispName1 = ((JdbcUrl)type1).getName();
            String dispName2 = ((JdbcUrl)type2).getName();
            if (dispName1 == null) {
                return dispName2 == null ? 0 : -1;
            }
            return dispName2 == null ? 1 : dispName1.compareToIgnoreCase(dispName2);
        }
    }

    private static final class DriverComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final JDBCDriverManager driverManager;
        private final ArrayList<JdbcUrl> driverList;
        private Object selectedItem;

        public DriverComboBoxModel(JDBCDriverManager driverManager, String driverClass) {
            this.driverManager = driverManager;
            this.driverList = new ArrayList();
            JDBCDriver[] drivers = driverClass != null ? driverManager.getDrivers(driverClass) : driverManager.getDrivers();
            for (int i = 0; i < drivers.length; ++i) {
                JDBCDriver driver = drivers[i];
                if (!JDBCDriverSupport.isAvailable(driver)) continue;
                this.driverList.addAll(DriverListUtil.getJdbcUrls(driver));
            }
            Collections.sort(this.driverList, new DriverTypeComparator());
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedItem = anItem;
        }

        @Override
        public Object getElementAt(int index) {
            return this.driverList.get(index);
        }

        @Override
        public int getSize() {
            return this.driverList.size();
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        public void addSelectedDriver(JDBCDriver driver) {
            List<JdbcUrl> types = DriverListUtil.getJdbcUrls(driver);
            assert (!types.isEmpty());
            this.driverList.addAll(types);
            this.setSelectedItem(types.get(0));
            Collections.sort(this.driverList, new DriverTypeComparator());
            this.fireContentsChanged(this, 0, this.driverList.size());
        }
    }

    private static final class DriverDataComboBoxModel
    implements DataComboBoxModel {
        private final JDBCDriverManager driverManager;
        private final DriverComboBoxModel comboBoxModel;

        public DriverDataComboBoxModel(JDBCDriverManager driverManager, String driverClass) {
            this.driverManager = driverManager;
            this.comboBoxModel = new DriverComboBoxModel(driverManager, driverClass);
        }

        @Override
        public String getItemTooltipText(Object item) {
            JdbcUrl url = (JdbcUrl)item;
            if (url.getDriver() == null) {
                return "";
            }
            return url.getDriver().toString();
        }

        @Override
        public String getItemDisplayName(Object item) {
            return ((JdbcUrl)item).getDisplayName();
        }

        @Override
        public void newItemActionPerformed() {
            HashSet<JDBCDriver> oldDrivers = new HashSet<JDBCDriver>(Arrays.asList(this.driverManager.getDrivers()));
            this.driverManager.showAddDriverDialog();
            JDBCDriver[] newDrivers = this.driverManager.getDrivers();
            if (newDrivers.length == oldDrivers.size()) {
                return;
            }
            for (int i = 0; i < newDrivers.length; ++i) {
                if (oldDrivers.contains(newDrivers[i])) continue;
                this.comboBoxModel.addSelectedDriver(newDrivers[i]);
                break;
            }
        }

        @Override
        public String getNewItemDisplayName() {
            return NbBundle.getMessage(DatabaseExplorerInternalUIs.class, (String)"LBL_NewDriver");
        }

        @Override
        public ComboBoxModel getListModel() {
            return this.comboBoxModel;
        }
    }
}

