/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.controllers;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.ConnectorConnectionPoolConfig;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.JDBCConnectionPoolConfig;
import com.sun.appserv.management.config.ModuleConfig;
import com.sun.appserv.management.config.ResourceConfig;
import com.sun.appserv.management.config.ResourceRefConfig;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.j2ee.J2EEManagedObject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.bridge.apis.AppserverMgmtController;
import org.netbeans.modules.j2ee.sun.util.AppserverConnectionFactory;
import org.netbeans.modules.j2ee.sun.util.GUIUtils;
import org.netbeans.modules.j2ee.sun.util.PluginRequestInterceptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerUtil {
    private static final String DELIMINATOR = " ";
    private static String PROPERTIES_INTERFACE = "PropertiesAccess";
    private static String DESCRIPTION_INTERFACE = "Description";
    private static String ENABLED_INTERFACE = "Enabled";
    private static String RESOURCE_CONFIG_INTERFACE = "ResourceConfig";
    private static String MODULE_CONFIG_INTERFACE = "ModuleConfig";
    private static String J2EE_DEPLOYED_OBJ_INTERFACE = "J2EEDeployedObject";
    private static String OBJECT_TYPE_INTERFACE = "ObjectType";
    private static String NAME_ATTRIBUTE = "Name";
    private static String JNDI_NAME_ATTRIBUTE = "JNDIName";
    private static final String CONFIG_OBJ_NAME = "com.sun.appserv:type=applications,category=config";
    private static final String SIP_CONFIG_MBEAN = "com.sun.appserv:type=sip-configs,category=config";
    private static final String SIP_MODULE_TYPE = "org.jvnet.glassfish.comms.deployment.backend.SipArchiveDeployer";
    private static Logger logger = Logger.getLogger("org.netbeans.modules.j2ee.sun");
    private static Map j2eeTypeToConfigMap = new HashMap();
    private static final String DAS_SERVER_NAME = "server";
    private static final String CONST_SET_PROP_EXCEPT = "unexpected_setProp_except";

    private ControllerUtil() {
    }

    public static AppserverMgmtController getAppserverMgmtControllerFromDeployMgr(DeploymentManager deployMgr) {
        AppserverConnectionSource con = ControllerUtil.createAppserverConnFromDeploymentMgr(deployMgr);
        if (con == null) {
            return null;
        }
        return new AppserverMgmtController(deployMgr, con);
    }

    public static AppserverConnectionSource createAppserverConnFromDeploymentMgr(DeploymentManager deployMgr) {
        AppserverConnectionSource connection = null;
        SunDeploymentManagerInterface sunDpmtMgr = (SunDeploymentManagerInterface)deployMgr;
        try {
            connection = AppserverConnectionFactory.getHTTPAppserverConnection(sunDpmtMgr.getHost(), sunDpmtMgr.getPort(), sunDpmtMgr.getUserName(), sunDpmtMgr.getPassword(), sunDpmtMgr.isSecure());
            connection.getDomainRoot();
        }
        catch (Exception ioex) {
            connection = null;
        }
        return connection;
    }

    public static MBeanServerConnection getMBeanServerConnWithInterceptor(SunDeploymentManagerInterface sunDplymtIntrface, AppserverConnectionSource connSource) {
        MBeanServerConnection conn = null;
        try {
            conn = connSource.getMBeanServerConnection(false);
        }
        catch (IOException io) {
            logger.log(Level.FINE, io.getMessage(), io);
        }
        PluginRequestInterceptor connWithInterceptor = new PluginRequestInterceptor(sunDplymtIntrface, conn);
        return connWithInterceptor;
    }

    public static AMX getAMXComponentFromMap(Map map, String keyName) {
        for (AMX component : map.values()) {
            if (!component.getName().equals(keyName)) continue;
            return component;
        }
        return null;
    }

    public static String[] getComponentNamesFromMap(Map map) {
        String[] names = new String[map.size()];
        int pos = 0;
        for (AMX component : map.values()) {
            names[pos] = component.getName();
            ++pos;
        }
        return names;
    }

    public static String[] getComponentNamesFromSet(Set components) {
        String[] names = new String[components.size()];
        ObjectName[] objs = ControllerUtil.convertToObjNames(components);
        for (int i = 0; i < objs.length; ++i) {
            ObjectName objName = objs[i];
            names[i] = objName.getKeyProperty("name");
        }
        return names;
    }

    public static String arrayToString(Object[] array) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            buffer.append(array[i]);
            buffer.append(DELIMINATOR);
        }
        return buffer.toString();
    }

    public static Map getAllAttributes(Class clazz, AMX amx, List propsToIgnore, MBeanServerConnection conn, String nodeType) {
        Map attrs = null;
        Set declaredAttrs = ControllerUtil.extractAttributeNamesFromMethods(ControllerUtil.getGetterMethods(clazz.getDeclaredMethods()));
        Set inheritedAttrs = ControllerUtil.getExtraAttributes(clazz);
        declaredAttrs.addAll(inheritedAttrs);
        if (ControllerUtil.isJNDINameAbsent(declaredAttrs)) {
            declaredAttrs.add(NAME_ATTRIBUTE);
        }
        if (nodeType.equals("WEB_APP")) {
            attrs = ControllerUtil.getAttributeProperties(ControllerUtil.applyFilterToAttributeNamesForWeb(propsToIgnore, declaredAttrs), amx, conn);
        } else {
            Set names = ControllerUtil.applyFilterToAttributeNames(propsToIgnore, declaredAttrs);
            if (nodeType.equals("APPCLIENT")) {
                names.add("JavaWebStartEnabled");
            }
            attrs = ControllerUtil.getAttributeProperties(names, amx, conn);
        }
        attrs = ControllerUtil.modifyEnabledProperty(attrs, amx);
        return attrs;
    }

    private static Set getExtraAttributes(Class clazz) {
        HashSet attrSet = new HashSet();
        Class<?>[] classes = clazz.getInterfaces();
        for (int i = 0; i < classes.length; ++i) {
            if (ControllerUtil.isExtraInterface(ControllerUtil.getSimpleClassName(classes[i]))) {
                attrSet.addAll(ControllerUtil.extractAttributeNamesFromMethods(ControllerUtil.getGetterMethods(classes[i].getDeclaredMethods())));
            }
            attrSet.addAll(ControllerUtil.getExtraAttributes(classes[i]));
        }
        return attrSet;
    }

    private static String getSimpleClassName(Class clazz) {
        String fullClassName = clazz.getName();
        int lastIndex = fullClassName.lastIndexOf(".");
        return fullClassName.substring(lastIndex + 1, fullClassName.length()).trim();
    }

    private static boolean isExtraInterface(String intrfaceName) {
        return DESCRIPTION_INTERFACE.equals(intrfaceName) || ENABLED_INTERFACE.equals(intrfaceName) || PROPERTIES_INTERFACE.equals(intrfaceName) || RESOURCE_CONFIG_INTERFACE.equals(intrfaceName) || J2EE_DEPLOYED_OBJ_INTERFACE.equals(intrfaceName) || MODULE_CONFIG_INTERFACE.equals(intrfaceName) || OBJECT_TYPE_INTERFACE.equals(intrfaceName);
    }

    private static boolean isJNDINameAbsent(Set attrs) {
        Iterator itr = attrs.iterator();
        while (itr.hasNext()) {
            if (!JNDI_NAME_ATTRIBUTE.equals(itr.next())) continue;
            return false;
        }
        return true;
    }

    private static Set applyFilterToAttributeNames(List propsToIgnore, Set names) {
        if (propsToIgnore != null && ControllerUtil.propsInListAreStrings(propsToIgnore)) {
            for (String name : propsToIgnore) {
                if (!names.contains(name)) continue;
                names.remove(name);
            }
        }
        return names;
    }

    private static Set applyFilterToAttributeNamesForWeb(List propsToAdd, Set names) {
        HashSet<String> attrNames = new HashSet<String>();
        if (propsToAdd == null) {
            return names;
        }
        if (propsToAdd != null && ControllerUtil.propsInListAreStrings(propsToAdd)) {
            for (String name : propsToAdd) {
                if (!names.contains(name)) continue;
                attrNames.add(name);
            }
        }
        return attrNames;
    }

    public static boolean propsInListAreStrings(List propsToIgnore) {
        Iterator itr = propsToIgnore.iterator();
        while (itr.hasNext()) {
            if (itr.next() instanceof String) continue;
            return false;
        }
        return true;
    }

    private static Map getAttributeProperties(Set names, AMX amx, MBeanServerConnection conn) {
        HashMap<Attribute, MBeanAttributeInfo> returnMap = new HashMap<Attribute, MBeanAttributeInfo>();
        ObjectName on = Util.getObjectName((AMX)amx);
        try {
            MBeanInfo mi = conn.getMBeanInfo(on);
            MBeanAttributeInfo[] mai = mi.getAttributes();
            for (int i = 0; i < mai.length; ++i) {
                if (mai[i] == null || !names.contains(mai[i].getName())) continue;
                try {
                    Object attrValue = conn.getAttribute(on, mai[i].getName());
                    returnMap.put(new Attribute(mai[i].getName(), attrValue), mai[i]);
                    continue;
                }
                catch (AttributeNotFoundException ex) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
        if (returnMap.size() == 0 || returnMap == null) {
            logger.log(Level.FINE, "The return Map in getAttrProperties is size 0!");
        }
        return returnMap;
    }

    public static Map getFilteredMBeanAttributes(Set names, ObjectName oName, MBeanServerConnection conn) {
        HashMap<Attribute, MBeanAttributeInfo> returnMap = new HashMap<Attribute, MBeanAttributeInfo>();
        try {
            MBeanInfo mi = conn.getMBeanInfo(oName);
            MBeanAttributeInfo[] mai = mi.getAttributes();
            for (int i = 0; i < mai.length; ++i) {
                try {
                    if (mai[i] == null || names.contains(mai[i].getName())) continue;
                    Object attrValue = conn.getAttribute(oName, mai[i].getName());
                    returnMap.put(new Attribute(mai[i].getName(), attrValue), mai[i]);
                    continue;
                }
                catch (AttributeNotFoundException ex) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
        if (returnMap.size() == 0 || returnMap == null) {
            logger.log(Level.FINE, "The return Map in getAttrProperties is size 0!");
        }
        return returnMap;
    }

    public static Set extractAttributeNamesFromMethods(Method[] method) {
        HashSet<String> attrNames = new HashSet<String>();
        for (int i = 0; i < method.length; ++i) {
            String methodName = method[i].getName();
            String name = methodName.substring(methodName.indexOf("get") + 3);
            attrNames.add(name);
        }
        return attrNames;
    }

    public static Method[] getGetterMethods(Method[] methods) {
        Vector<Method> v = new Vector<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().startsWith("get") || methods[i].getName().endsWith("Stats")) continue;
            v.add(methods[i]);
        }
        Method[] mm = new Method[v.size()];
        return v.toArray(mm);
    }

    public static AMX getConfigPeer(AMX amx) {
        J2EEManagedObject managedObj = (J2EEManagedObject)amx;
        AMXConfig configPeer = managedObj.getConfigPeer();
        if (configPeer != null) {
            return configPeer;
        }
        String configXType = ControllerUtil.getConfigPeerAMXType(amx.getJ2EEType());
        QueryMgr queryMgr = amx.getDomainRoot().getQueryMgr();
        Set set = queryMgr.queryJ2EETypeSet(configXType);
        for (AMX config : set) {
            if (!config.getName().equals(amx.getName())) continue;
            return config;
        }
        return null;
    }

    public static Attribute setAttributeValue(AMX j2eeMod, AMX configPeer, String attrName, Object value, MBeanServerConnection conn) {
        Attribute modAttr = new Attribute(attrName, value);
        try {
            if (attrName.equals("Enabled") && configPeer != null) {
                ControllerUtil.updateEnabled(configPeer, value);
            } else {
                ObjectName configOn = Util.getObjectName((AMX)configPeer);
                conn.setAttribute(configOn, modAttr);
            }
        }
        catch (RuntimeMBeanException e) {
            if (j2eeMod != null) {
                ObjectName j2eeOn = Util.getObjectName((AMX)j2eeMod);
                modAttr = ControllerUtil.setAttrValue(j2eeOn, attrName, modAttr, conn);
            } else {
                modAttr = null;
            }
        }
        catch (Exception ex) {
            Object[] params = new Object[]{attrName, ex.getMessage()};
            GUIUtils.showError(ControllerUtil.getLocalizedString("unexpected_setAttr_except", params));
            modAttr = null;
        }
        return modAttr;
    }

    public static Attribute setAttributeValue(AMX amx, String attrName, Object value, MBeanServerConnection conn) {
        ObjectName on = Util.getObjectName((AMX)amx);
        Attribute modAttr = new Attribute(attrName, value);
        try {
            if (attrName.equals("Enabled") && amx != null) {
                ControllerUtil.updateEnabled(amx, value);
            } else {
                conn.setAttribute(on, modAttr);
            }
        }
        catch (RuntimeMBeanException e) {
            modAttr = ControllerUtil.setAttributeOnConfigPeer(amx, attrName, value, conn);
        }
        catch (Exception ex) {
            Object[] params = new Object[]{attrName, ex.getMessage()};
            GUIUtils.showError(ControllerUtil.getLocalizedString("unexpected_setAttr_except", params));
            modAttr = null;
        }
        return modAttr;
    }

    public static Attribute setAttributeValue(ObjectName oname, String attrName, Object value, MBeanServerConnection conn) {
        Attribute modAttr = new Attribute(attrName, value);
        try {
            conn.setAttribute(oname, modAttr);
        }
        catch (Exception ex) {
            Object[] params = new Object[]{attrName, ex.getMessage()};
            GUIUtils.showError(ControllerUtil.getLocalizedString("unexpected_setAttr_except", params));
            modAttr = null;
        }
        return modAttr;
    }

    private static void updateEnabled(AMX amx, Object value) {
        if (amx instanceof ResourceConfig) {
            ControllerUtil.setResourceEnabled((ResourceConfig)amx, value);
        } else if (amx instanceof ModuleConfig) {
            ControllerUtil.setModuleEnabled((ModuleConfig)amx, value);
        }
    }

    private static Attribute setAttrValue(ObjectName on, String attrName, Attribute modAttr, MBeanServerConnection conn) {
        try {
            conn.setAttribute(on, modAttr);
        }
        catch (Exception ex) {
            Object[] params = new Object[]{attrName, ex.getMessage()};
            GUIUtils.showError(ControllerUtil.getLocalizedString("unexpected_setAttr_except", params));
            modAttr = null;
        }
        return modAttr;
    }

    public static void setPropertyValue(ResourceConfig resConfig, Object[] props) {
        try {
            for (int i = 0; i < props.length; ++i) {
                Attribute attr = (Attribute)props[i];
                String propValue = null;
                if (attr.getValue() != null) {
                    propValue = attr.getValue().toString();
                }
                resConfig.setPropertyValue(attr.getName(), propValue);
            }
        }
        catch (RuntimeMBeanException e) {
            Object[] params = new Object[]{resConfig.getJNDIName(), e.getMessage()};
            GUIUtils.showError(ControllerUtil.getLocalizedString(CONST_SET_PROP_EXCEPT, params));
        }
        catch (Exception ex) {
            Object[] params = new Object[]{resConfig.getJNDIName(), ex.getMessage()};
            GUIUtils.showError(ControllerUtil.getLocalizedString(CONST_SET_PROP_EXCEPT, params));
        }
    }

    public static void setPropertyValue(JDBCConnectionPoolConfig resConfig, Object[] props) {
        try {
            for (int i = 0; i < props.length; ++i) {
                Attribute attr = (Attribute)props[i];
                String propValue = null;
                if (attr.getValue() != null) {
                    propValue = attr.getValue().toString();
                }
                resConfig.setPropertyValue(attr.getName(), propValue);
            }
        }
        catch (RuntimeMBeanException e) {
            Object[] params = new Object[]{resConfig.getName(), e.getMessage()};
            GUIUtils.showError(ControllerUtil.getLocalizedString(CONST_SET_PROP_EXCEPT, params));
        }
        catch (Exception ex) {
            Object[] params = new Object[]{resConfig.getName(), ex.getMessage()};
            GUIUtils.showError(ControllerUtil.getLocalizedString(CONST_SET_PROP_EXCEPT, params));
        }
    }

    public static void setPropertyValue(ConnectorConnectionPoolConfig resConfig, Object[] props) {
        try {
            for (int i = 0; i < props.length; ++i) {
                Attribute attr = (Attribute)props[i];
                String propValue = null;
                if (attr.getValue() != null) {
                    propValue = attr.getValue().toString();
                }
                resConfig.setPropertyValue(attr.getName(), propValue);
            }
        }
        catch (RuntimeMBeanException e) {
            Object[] params = new Object[]{resConfig.getName(), e.getMessage()};
            GUIUtils.showError(ControllerUtil.getLocalizedString(CONST_SET_PROP_EXCEPT, params));
        }
        catch (Exception ex) {
            Object[] params = new Object[]{resConfig.getName(), ex.getMessage()};
            GUIUtils.showError(ControllerUtil.getLocalizedString(CONST_SET_PROP_EXCEPT, params));
        }
    }

    private static Attribute setAttributeOnConfigPeer(AMX amx, String attrName, Object value, MBeanServerConnection conn) {
        AMX configPeer = ControllerUtil.getConfigPeer(amx);
        Attribute modAttr = new Attribute(attrName, value);
        try {
            ObjectName on = Util.getObjectName((AMX)configPeer);
            conn.setAttribute(on, modAttr);
        }
        catch (RuntimeMBeanException e) {
            Object[] params = new Object[]{attrName, e.getMessage()};
            GUIUtils.showError(ControllerUtil.getLocalizedString("unexpected_setAttrConfigPeer_except", params));
            modAttr = null;
        }
        catch (Exception ex) {
            Object[] params = new Object[]{attrName, ex.getMessage()};
            GUIUtils.showError(ControllerUtil.getLocalizedString("unexpected_setAttrConfigPeer_except", params));
            modAttr = null;
        }
        return modAttr;
    }

    protected static Map stripOutSystemApps(Map allModules) {
        HashMap<String, J2EEManagedObject> deployedObjects = new HashMap<String, J2EEManagedObject>();
        for (J2EEManagedObject j2eeModule : allModules.values()) {
            ModuleConfig appConfig = (ModuleConfig)j2eeModule.getConfigPeer();
            if (appConfig == null || !"user".equals(appConfig.getObjectType())) continue;
            deployedObjects.put(j2eeModule.getName(), j2eeModule);
        }
        return deployedObjects;
    }

    public static String getConfigPeerAMXType(String j2eeType) {
        return (String)j2eeTypeToConfigMap.get(j2eeType);
    }

    public static void checkIfServerInDebugMode(DeploymentManager dplymtMgr) {
        SunDeploymentManagerInterface sunDpmtMgr = (SunDeploymentManagerInterface)dplymtMgr;
        if (sunDpmtMgr != null && sunDpmtMgr.isSuspended()) {
            GUIUtils.showInformation(ControllerUtil.getLocalizedString("server_dbg_mode_notify"));
            throw new RuntimeException(ControllerUtil.getLocalizedString("server_dbg_mode_notify"));
        }
    }

    public static Map getLogAttributes(AMX config, Map propNames, MBeanServerConnection conn) {
        HashMap<Attribute, MBeanAttributeInfo> returnMap = new HashMap<Attribute, MBeanAttributeInfo>();
        ObjectName on = Util.getObjectName((AMX)config);
        try {
            MBeanInfo mi = conn.getMBeanInfo(on);
            MBeanAttributeInfo[] mai = mi.getAttributes();
            for (int i = 0; i < mai.length; ++i) {
                if (mai[i] == null || !propNames.containsKey(mai[i].getName())) continue;
                try {
                    Object attrValue = conn.getAttribute(on, mai[i].getName());
                    returnMap.put(new Attribute(mai[i].getName(), attrValue), mai[i]);
                    continue;
                }
                catch (AttributeNotFoundException ex) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
        if (returnMap.size() == 0 || returnMap == null) {
            logger.log(Level.FINE, "The return Map in getAttrProperties is size 0!");
        }
        return returnMap;
    }

    private static String getLocalizedString(String bundleStrProp) {
        return NbBundle.getMessage(ControllerUtil.class, (String)bundleStrProp);
    }

    private static String getLocalizedString(String bundleStrProp, Object[] params) {
        return NbBundle.getMessage(ControllerUtil.class, (String)bundleStrProp, (Object[])params);
    }

    public static boolean isGlassFish(DeploymentManager dm) {
        File candidate = ((SunDeploymentManagerInterface)dm).getPlatformRoot();
        File as9 = new File(candidate.getAbsolutePath() + "/lib/dtds/sun-web-app_2_5-0.dtd");
        return as9.exists();
    }

    public static ObjectName[] getSubComponentsFromConfig(String modName, MBeanServerConnection conn) {
        String[] subComponents = new String[]{};
        try {
            ObjectName oName = new ObjectName(CONFIG_OBJ_NAME);
            Object[] params = new Object[]{modName};
            String[] signature = new String[]{"java.lang.String"};
            subComponents = (String[])conn.invoke(oName, "getModuleComponents", params, signature);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ControllerUtil.convertToObjNames(subComponents);
    }

    public static ObjectName[] getSIPComponents(MBeanServerConnection conn) {
        ObjectName[] subComponents = new ObjectName[]{};
        try {
            ObjectName oName = new ObjectName(CONFIG_OBJ_NAME);
            Object[] params = null;
            String[] signature = null;
            subComponents = (ObjectName[])conn.invoke(oName, "getExtensionModule", params, signature);
            if (subComponents != null && subComponents.length > 0) {
                ArrayList<ObjectName> list = new ArrayList<ObjectName>();
                for (ObjectName child : subComponents) {
                    String moduleType = (String)conn.getAttribute(child, "module-type");
                    if (!SIP_MODULE_TYPE.equals(moduleType)) continue;
                    AttributeList props = (AttributeList)conn.invoke(child, "getProperties", null, null);
                    list.add(child);
                }
                if (list.size() > 0) {
                    subComponents = (ObjectName[])list.toArray();
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.FINE, ex.getMessage(), ex);
        }
        return subComponents;
    }

    protected static String isConvergedSIP(ObjectName objName, MBeanServerConnection conn) {
        String sipType = "SIPAPP_CONVERGED";
        boolean converged = Boolean.parseBoolean((String)ControllerUtil.getPropertyValue(objName, "isConverged", conn));
        if (!converged) {
            sipType = "SIPAPP";
        }
        return sipType;
    }

    private static ObjectName[] convertToObjNames(String[] objNames) {
        try {
            ObjectName[] compNames = new ObjectName[objNames.length];
            for (int i = 0; i < objNames.length; ++i) {
                ObjectName name;
                compNames[i] = name = new ObjectName(objNames[i]);
            }
            return compNames;
        }
        catch (Exception ex) {
            return new ObjectName[0];
        }
    }

    private static ObjectName[] convertToObjNames(Set objNames) {
        try {
            ObjectName[] compNames = new ObjectName[objNames.size()];
            int pos = 0;
            Iterator it = objNames.iterator();
            while (it.hasNext()) {
                ObjectName name;
                compNames[pos] = name = new ObjectName(it.next().toString());
                ++pos;
            }
            return compNames;
        }
        catch (Exception ex) {
            return new ObjectName[0];
        }
    }

    private static void setResourceEnabled(ResourceConfig resConfig, Object value) {
        boolean val = Boolean.valueOf(value.toString());
        ResourceRefConfig config = ControllerUtil.getResourceRefConfig((AMX)resConfig);
        if (config != null) {
            config.setEnabled(val);
        }
    }

    private static void setModuleEnabled(ModuleConfig modConfig, Object value) {
        boolean val = Boolean.valueOf(value.toString());
        DeployedItemRefConfig config = ControllerUtil.getDeployedItemRefConfig((AMX)modConfig);
        if (config != null) {
            config.setEnabled(val);
        }
    }

    private static ResourceRefConfig getResourceRefConfig(AMX appConfig) {
        String appName = appConfig.getName();
        ResourceRefConfig itemName = (ResourceRefConfig)ControllerUtil.getDASConfig(appConfig).getResourceRefConfigMap().get(appName);
        return itemName;
    }

    private static ServerConfig getDASConfig(AMX appConfig) {
        Map serverConfigs = ControllerUtil.getServerInstancesMap(appConfig);
        ServerConfig serverConfig = (ServerConfig)serverConfigs.get(DAS_SERVER_NAME);
        return serverConfig;
    }

    public static Map modifyEnabledProperty(Map j2eeProps, AMX configPeer) {
        Map modProps = j2eeProps;
        for (Attribute attr : j2eeProps.keySet()) {
            if (!attr.getName().equals("Enabled")) continue;
            MBeanAttributeInfo info = (MBeanAttributeInfo)j2eeProps.get(attr);
            Boolean value = (Boolean)attr.getValue();
            boolean attrVal = ControllerUtil.calculateIsEnabled(configPeer, value);
            Attribute enabled = new Attribute("Enabled", attrVal);
            modProps.remove(attr);
            modProps.put(enabled, info);
            break;
        }
        return modProps;
    }

    protected static boolean calculateIsEnabled(AMX appConfig, boolean configEnabled) {
        boolean isEnabled = configEnabled;
        boolean refEnabled = configEnabled;
        if (appConfig instanceof ResourceConfig) {
            ResourceRefConfig itemName = ControllerUtil.getResourceRefConfig(appConfig);
            if (itemName != null) {
                refEnabled = itemName.getEnabled();
            }
        } else {
            DeployedItemRefConfig itemName = ControllerUtil.getDeployedItemRefConfig(appConfig);
            if (itemName != null) {
                refEnabled = itemName.getEnabled();
            }
        }
        if (!configEnabled || !refEnabled) {
            isEnabled = false;
        }
        return isEnabled;
    }

    protected static DeployedItemRefConfig getDeployedItemRefConfig(AMX appConfig) {
        String appName = appConfig.getName();
        DeployedItemRefConfig itemName = (DeployedItemRefConfig)ControllerUtil.getDASConfig(appConfig).getDeployedItemRefConfigMap().get(appName);
        return itemName;
    }

    public static String[] getServerTargets(AMX amx) {
        return ControllerUtil.getComponentNamesFromMap(ControllerUtil.getServerInstancesMap(amx));
    }

    public static Map getServerInstancesMap(AMX amx) {
        Map serverConfigs = amx.getDomainRoot().getDomainConfig().getServerConfigMap();
        return serverConfigs;
    }

    public static Map getStandaloneServerInstancesMap(AMX amx) {
        Map serverConfigs = amx.getDomainRoot().getDomainConfig().getStandaloneServerConfigMap();
        return serverConfigs;
    }

    public static List<String> getDeployedTargets(AMX amx, boolean isApp, MBeanServerConnection conn) throws Exception {
        ArrayList<String> targetList = new ArrayList<String>();
        Map clusterConfigs = amx.getDomainRoot().getDomainConfig().getClusterConfigMap();
        if (clusterConfigs.size() > 0) {
            String appName = amx.getName();
            String objectName = isApp ? CONFIG_OBJ_NAME : "com.sun.appserv:type=resources,category=config";
            Object[] params = new String[]{appName};
            String[] types = new String[]{"java.lang.String"};
            ObjectName[] refs = (ObjectName[])conn.invoke(new ObjectName(objectName), "listReferencees", params, types);
            for (int i = 0; i < refs.length; ++i) {
                targetList.add(refs[i].getKeyProperty("name"));
            }
        }
        return targetList;
    }

    protected static Map getDeployedObjects(Map allObjects) {
        HashMap<String, ModuleConfig> deployedObjects = new HashMap<String, ModuleConfig>();
        for (Object configObj : allObjects.values()) {
            ModuleConfig appConfig;
            if (!(configObj instanceof AMXConfig) && !(configObj instanceof ModuleConfig)) continue;
            if (configObj instanceof ModuleConfig) {
                appConfig = (ModuleConfig)configObj;
                if (!"user".equals(appConfig.getObjectType())) continue;
                deployedObjects.put(appConfig.getName(), appConfig);
                continue;
            }
            if (!(configObj instanceof AMXConfig)) continue;
            appConfig = (AMXConfig)configObj;
            deployedObjects.put(appConfig.getName(), appConfig);
        }
        return deployedObjects;
    }

    public static boolean isSIPEnabled(MBeanServerConnection conn) {
        boolean enabled = false;
        try {
            ObjectName objectName = new ObjectName(SIP_CONFIG_MBEAN);
            MBeanInfo mbeanInstance = conn.getMBeanInfo(objectName);
            enabled = true;
        }
        catch (InstanceNotFoundException ex) {
            enabled = false;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, ex.getMessage(), ex);
        }
        return enabled;
    }

    public static Object getPropertyValue(ObjectName objName, String propName, MBeanServerConnection conn) {
        try {
            AttributeList props = (AttributeList)conn.invoke(objName, "getProperties", null, null);
            for (Attribute attribute : props) {
                String name = attribute.getName();
                if (!name.equals(propName)) continue;
                return attribute.getValue();
            }
            return null;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static String getAttributeValue(ObjectName objName, String attrName, MBeanServerConnection conn) {
        String strValue = "";
        try {
            Object attrValue = conn.getAttribute(objName, attrName);
            if (attrValue != null) {
                strValue = attrValue.toString();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return strValue;
    }

    protected static boolean isModEnabled(ObjectName objName, MBeanServerConnection conn) {
        String val = ControllerUtil.getAttributeValue(objName, "enabled", conn);
        boolean isEnabled = Boolean.valueOf(val.toString());
        return isEnabled;
    }

    static {
        j2eeTypeToConfigMap.put("J2EEDomain", "X-DomainConfig");
        j2eeTypeToConfigMap.put("X-J2EECluster", "X-ClusterConfig");
        j2eeTypeToConfigMap.put("J2EEServer", "X-StandaloneServerConfig");
        j2eeTypeToConfigMap.put("JVM", "X-JavaConfig");
        j2eeTypeToConfigMap.put("J2EEApplication", "X-J2EEApplicationConfig");
        j2eeTypeToConfigMap.put("EJBModule", "X-EJBModuleConfig");
        j2eeTypeToConfigMap.put("WebModule", "X-WebModuleConfig");
        j2eeTypeToConfigMap.put("AppClientModule", "X-AppClientModuleConfig");
        j2eeTypeToConfigMap.put("ResourceAdapterModule", "X-RARModuleConfig");
        j2eeTypeToConfigMap.put("ResourceAdapter", "X-ResourceAdapterConfig");
    }
}

