/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.web.export;

import com.sun.star.io.IOException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.wizards.ui.event.Task;
import com.sun.star.wizards.web.data.CGDocument;
import com.sun.star.wizards.web.data.CGSession;
import com.sun.star.wizards.web.export.ConfiguredExporter;

public class ImpressHTMLExporter
extends ConfiguredExporter {
    private static final Integer SMALL_IMAGE = new Integer(512);
    private static final Integer MEDIUM_IMAGE = new Integer(640);
    private static final Integer LARGE_IMAGE = new Integer(800);

    public boolean export(CGDocument cGDocument, String string, XMultiServiceFactory xMultiServiceFactory, Task task) throws IOException {
        CGSession cGSession = this.getSession(cGDocument);
        this.props.put("Author", cGDocument.cp_Author);
        this.props.put("Email", cGSession.cp_GeneralInfo.cp_Email);
        this.props.put("HomepageURL", this.getHomepageURL(cGSession));
        this.props.put("UserText", cGDocument.cp_Title);
        this.props.put("Width", this.getImageWidth(cGSession));
        this.props.put("UseButtonSet", new Integer(cGSession.cp_Design.cp_IconSet));
        return super.export(cGDocument, string, xMultiServiceFactory, task);
    }

    private String getHomepageURL(CGSession cGSession) {
        return "../" + (this.exporter.cp_OwnDirectory ? "../index.html" : "index.html");
    }

    private Integer getImageWidth(CGSession cGSession) {
        switch (cGSession.cp_Design.cp_OptimizeDisplaySize) {
            case 0: {
                return SMALL_IMAGE;
            }
            case 1: {
                return MEDIUM_IMAGE;
            }
            case 2: {
                return LARGE_IMAGE;
            }
        }
        return MEDIUM_IMAGE;
    }

    private CGSession getSession(CGDocument cGDocument) {
        return cGDocument.getSettings().cp_DefaultSession;
    }
}

