/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul;

import de.tu_darmstadt.sp.paul.PDFInteger;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFWriter;
import java.io.IOException;
import java.io.Writer;

public class PDFReference
extends PDFObject
implements Comparable {
    PDFObject content;
    int objNumber;
    int genNumber;
    static final String OBJ = " obj\n";
    static final String ENDOBJ = "\nendobj\n";

    public PDFReference(int objNumber, int genNumber) {
        this.objNumber = objNumber;
        this.genNumber = genNumber;
    }

    public PDFReference(int objNumber, int genNumber, PDFObject content) {
        if (content == null) {
            throw new NullPointerException("content may not be null");
        }
        if (content instanceof PDFReference) {
            throw new IllegalArgumentException("content may not be an instance of PDFReference");
        }
        this.objNumber = objNumber;
        this.genNumber = genNumber;
        this.content = content;
        this.setDirect();
    }

    public PDFReference(PDFInteger objNumber, PDFInteger genNumber) {
        this(objNumber.intValue(), genNumber.intValue());
    }

    public PDFReference(PDFInteger objNumber, PDFInteger genNumber, PDFObject content) {
        this(objNumber.intValue(), genNumber.intValue(), content);
    }

    public int compareTo(Object o) {
        int check = this.objNumber - ((PDFReference)o).objNumber;
        if (check == 0) {
            check = this.genNumber - ((PDFReference)o).genNumber;
        }
        return check;
    }

    public boolean equals(Object obj) {
        return obj instanceof PDFReference && this.objNumber == ((PDFReference)obj).objNumber && this.genNumber == ((PDFReference)obj).genNumber;
    }

    public PDFObject getContent() {
        return this.content;
    }

    public int getGenNumber() {
        return this.genNumber;
    }

    public int getObjNumber() {
        return this.objNumber;
    }

    void getReferenced(PDFWriter writer) {
    }

    public int hashCode() {
        return this.objNumber + this.genNumber;
    }

    public String toString() {
        return String.valueOf(Integer.toString(this.objNumber)) + " " + Integer.toString(this.genNumber);
    }

    public void write(Writer out) throws IOException {
        out.write(this.toString());
        out.write(" R");
    }

    public void writeContent(Writer out) throws IOException {
        out.write(this.toString());
        out.write(OBJ);
        this.content.write(out);
        out.write(ENDOBJ);
    }
}

