/*
*  RAL -- Rubrica Addressbook Library
*  file: timeout.h
*
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __R_TIMEOUT_H
#define __R_TIMEOUT_H


#include <glib.h>
#include <glib-object.h>


#define R_TIMEOUT_TYPE            (r_timeout_get_type())

#define R_TIMEOUT(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),    \
                                   R_TIMEOUT_TYPE, RTimeout))

#define R_TIMEOUT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),     \
                                   R_TIMEOUT_TYPE, RTimeoutClass))

#define IS_R_TIMEOUT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),    \
                                   R_TIMEOUT_TYPE))

#define IS_R_TIMEOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),     \
                                   R_TIMEOUT_TYPE))

#define R_TIMEOUT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),     \
                                   R_TIMEOUT_TYPE, RTimeoutClass))


typedef struct _RTimeout          RTimeout;
typedef struct _RTimeoutClass     RTimeoutClass;
typedef struct _RTimeoutPrivate   RTimeoutPrivate;


struct _RTimeout 
{
  GObject parent;

  guint32 wait_time; 

  RTimeoutPrivate* private;
};

struct _RTimeoutClass
{
  GObjectClass parent;

  /* signals */
  void (*timeout_signal) (RTimeout* timeout);
};


GType     r_timeout_get_type   (void);

RTimeout* r_timeout_new        (guint32 time);
void      r_timeout_free       (RTimeout* timeout);

void      r_timeout_start      (RTimeout* timeout);
void      r_timeout_enable     (RTimeout* timeout);
void      r_timeout_disable    (RTimeout* timeout);
void      r_timeout_restart    (RTimeout* timeout, guint32 time);

gboolean  r_timeout_is_running (RTimeout* timeout);

#endif
