'\"
'\" Generated from file '/usr/ports/pobj/tcllib-1.11.1/tcllib-1.11.1/modules/grammar_me/me_cpu.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2005-2006 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "grammar::me::cpu" n 0.2 grammar_me "Grammar operations and usage"
.BS
.SH NAME
grammar::me::cpu \- Virtual machine implementation II for parsing token streams
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBgrammar::me::cpu  ?0.2?\fR
.sp
\fB::grammar::me::cpu\fR \fImeName\fR \fImatchcode\fR
.sp
\fBmeName\fR \fBoption\fR ?\fIarg arg ...\fR?
.sp
\fImeName\fR \fBlc\fR \fIlocation\fR
.sp
\fImeName\fR \fBtok\fR ?\fIfrom\fR ?\fIto\fR??
.sp
\fImeName\fR \fBpc\fR \fIstate\fR
.sp
\fImeName\fR \fBiseof\fR \fIstate\fR
.sp
\fImeName\fR \fBat\fR \fIstate\fR
.sp
\fImeName\fR \fBcc\fR \fIstate\fR
.sp
\fImeName\fR \fBsv\fR
.sp
\fImeName\fR \fBok\fR
.sp
\fImeName\fR \fBerror\fR
.sp
\fImeName\fR \fBlstk\fR \fIstate\fR
.sp
\fImeName\fR \fBastk\fR \fIstate\fR
.sp
\fImeName\fR \fBmstk\fR \fIstate\fR
.sp
\fImeName\fR \fBestk\fR \fIstate\fR
.sp
\fImeName\fR \fBrstk\fR \fIstate\fR
.sp
\fImeName\fR \fBnc\fR \fIstate\fR
.sp
\fImeName\fR \fBast\fR
.sp
\fImeName\fR \fBhalted\fR
.sp
\fImeName\fR \fBcode\fR
.sp
\fImeName\fR \fBeof\fR
.sp
\fImeName\fR \fBput\fR \fItok\fR \fIlex\fR \fIline\fR \fIcol\fR
.sp
\fImeName\fR \fBputstring\fR \fIstring\fR \fIlvar\fR \fIcvar\fR
.sp
\fImeName\fR \fBrun\fR ?\fIn\fR?
.sp
\fImeName\fR \fBpull\fR \fInextcmd\fR
.sp
\fImeName\fR \fBreset\fR
.sp
\fImeName\fR \fBdestroy\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides an implementation of the ME virtual machine.
Please go and read the document \fBgrammar::me_intro\fR first if
you do not know what a ME virtual machine is.
.PP
This implementation provides an object-based API and the machines are
not truly tied to Tcl. A C implementation of the same API is quite
possible.
.PP
Internally the package actually uses the value-based machine
manipulation commands as provided by the package
\fBgrammar::me::cpu::core\fR to perform its duties.
.SH API
.SS "CLASS API"
The package directly provides only a single command for the
construction of ME virtual machines.
.TP
\fB::grammar::me::cpu\fR \fImeName\fR \fImatchcode\fR
The command creates a new ME machine object with an associated global
Tcl command whose name is \fImeName\fR. This command may be used to
invoke various operations on the machine.
It has the following general form:
.RS
.TP
\fBmeName\fR \fBoption\fR ?\fIarg arg ...\fR?
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.
.RE
.sp
The argument \fImatchcode\fR contains the match instructions the
machine has to execute while parsing the input stream. Please read
section \fBMATCH CODE REPRESENTATION\fR of the
documentation for the package \fBgrammar::me::cpu::core\fR for
the specification of the structure of this value.
.sp
The \fItokmap\fR argument taken by the implementation provided by the
package \fBgrammar::me::tcl\fR is here hidden inside of the match
instructions and therefore not needed.
.PP
.PP
.SS "OBJECT API"
All ME virtual machine objects created by the class command specified
in section \fBCLASS API\fR support the methods listed below.
.PP
The machines provided by this package provide methods for operation in
both push- and pull-styles. Push-style means that tokens are pushed
into the machine state when they arrive, triggering further execution
until they are consumed. In other words, this allows the machine to be
suspended and resumed at will and an arbitrary number of times, the
quasi-parallel operation of several machines, and the operation as
part of the event loop.
.TP
\fImeName\fR \fBlc\fR \fIlocation\fR
This method converts the location of a token given as offset in the
input stream into the associated line number and column index. The
result of the command is a 2-element list containing the two values,
in the order mentioned in the previous sentence.
This allows higher levels to convert the location information found in
the error status and the generated AST into more human readable data.
.sp
\fINote\fR that the command is not able to convert locations which
have not been reached by the machine yet. In other words, if the
machine has read 7 tokens the command is able to convert the offsets
\fB0\fR to \fB6\fR, but nothing beyond that. This also shows that
it is not possible to convert offsets which refer to locations before
the beginning of the stream.
.TP
\fImeName\fR \fBtok\fR ?\fIfrom\fR ?\fIto\fR??
This method returns a Tcl list containing the part of the input stream
between the locations \fIfrom\fR and \fIto\fR (both inclusive). If
\fIto\fR is not specified it will default to the value of \fIfrom\fR.
If \fIfrom\fR is not specified either the whole input stream is returned.
.sp
Each element of the returned list is a list of four elements, the
token, its associated lexeme, line number, and column index, in this
order.
This command places the same restrictions on its location arguments as
the method \fBlc\fR.
.TP
\fImeName\fR \fBpc\fR \fIstate\fR
This method takes the state value of a ME virtual machine and returns
the current value of the stored program counter.
.TP
\fImeName\fR \fBiseof\fR \fIstate\fR
This method takes the state value of a ME virtual machine and returns
the current value of the stored eof flag.
.TP
\fImeName\fR \fBat\fR \fIstate\fR
This method takes the state value of a ME virtual machine and returns
the current location in the input stream.
.TP
\fImeName\fR \fBcc\fR \fIstate\fR
This method takes the state value of a ME virtual machine and returns
the current token.
.TP
\fImeName\fR \fBsv\fR
This command returns the current semantic value \fISV\fR stored in
the machine. This is an abstract syntax tree as specified in the
document \fBgrammar::me_ast\fR, section \fBAST VALUES\fR.
.TP
\fImeName\fR \fBok\fR
This method returns the current match status \fIOK\fR.
.TP
\fImeName\fR \fBerror\fR
This method returns the current error status \fIER\fR.
.TP
\fImeName\fR \fBlstk\fR \fIstate\fR
This method takes the state value of a ME virtual machine and returns
the location stack.
.TP
\fImeName\fR \fBastk\fR \fIstate\fR
This method takes the state value of a ME virtual machine and returns
the AST stack.
.TP
\fImeName\fR \fBmstk\fR \fIstate\fR
This method takes the state value of a ME virtual machine and returns
the AST marker stack.
.TP
\fImeName\fR \fBestk\fR \fIstate\fR
This method takes the state value of a ME virtual machine and returns
the error stack.
.TP
\fImeName\fR \fBrstk\fR \fIstate\fR
This method takes the state value of a ME virtual machine and returns
the subroutine return stack.
.TP
\fImeName\fR \fBnc\fR \fIstate\fR
This method takes the state value of a ME virtual machine and returns
the nonterminal match cache as a dictionary.
.TP
\fImeName\fR \fBast\fR
This method returns the current top entry of the AST stack \fIAS\fR.
This is an abstract syntax tree as specified in the document
\fBgrammar::me_ast\fR, section \fBAST VALUES\fR.
.TP
\fImeName\fR \fBhalted\fR
This method returns a boolean value telling the caller whether the
engine has halted execution or not. Halt means that no further
matching is possible, and the information retrieved via the other
method is final. Attempts to \fBrun\fR the engine will be ignored,
until a \fBreset\fR is made.
.TP
\fImeName\fR \fBcode\fR
This method returns the \fIcode\fR information used to construct the
object. In other words, the match program executed by the machine.
.TP
\fImeName\fR \fBeof\fR
This method adds an end of file marker to the end of the input stream.
This signals the machine that the current contents of the input queue
are the final parts of the input and nothing will come after. Attempts
to put more characters into the queue will fail.
.TP
\fImeName\fR \fBput\fR \fItok\fR \fIlex\fR \fIline\fR \fIcol\fR
This method adds the token \fItok\fR to the end of the input stream,
with associated lexeme data \fIlex\fR and \fIline\fR/\fIcol\fRumn
information.
.TP
\fImeName\fR \fBputstring\fR \fIstring\fR \fIlvar\fR \fIcvar\fR
This method adds each individual character in the \fIstring\fR as a
token to the end of the input stream, from first to last. The lexemes
will be empty and the line/col information is computed based on the
characters encountered and the data in the variables \fIlvar\fR and
\fIcvar\fR.
.TP
\fImeName\fR \fBrun\fR ?\fIn\fR?
This methods causes the engine to execute match instructions until
either
.RS
.IP \(bu
\fIn\fR instructions have been executed, or
.IP \(bu
a halt instruction was executed, or
.IP \(bu
the input queue is empty and the code is asking for more tokens to
process.
.RE
.sp
If no limit \fIn\fR was set only the last two conditions are checked
for.
.TP
\fImeName\fR \fBpull\fR \fInextcmd\fR
This method implements pull-style operation of the machine. It causes
it to execute match instructions until either a halt instruction is
reached, or the command prefix
\fInextcmd\fR ceases to deliver more tokens.
.sp
The command prefix \fInextcmd\fR represents the input stream of
characters and is invoked by the machine whenever the a new character
from the stream is required. The instruction for handling this is
\fIict_advance\fR.
The callback has to return either the empty list, or a list of 4
elements containing the token, its lexeme attribute, and its location
as line number and column index, in this order.
The empty list is the signal that the end of the input stream has been
reached. The lexeme attribute is stored in the terminal cache, but
otherwise not used by the machine.
.sp
The end of the input stream for this method does not imply that method
\fBeof\fR is called for the machine as a whole. By avoiding this
and still asking for an explicit call of the method it is possible to
mix push- and pull-style operation during the lifetime of the machine.
.TP
\fImeName\fR \fBreset\fR
This method resets the machine to its initial state, discarding any
state it may have.
.TP
\fImeName\fR \fBdestroy\fR
This method deletes the object and releases all resurces it claimed.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIgrammar_me\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
grammar, parsing, virtual machine
.SH COPYRIGHT
.nf
Copyright (c) 2005-2006 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi