/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlWriter;

public class XmlRpcResponseProcessor {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] processResponse(Object object, String string) throws IOException, UnsupportedEncodingException, XmlRpcException {
        long l = 0L;
        if (XmlRpc.debug) {
            l = System.currentTimeMillis();
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XmlWriter xmlWriter = new XmlWriter((OutputStream)byteArrayOutputStream, string);
            this.writeResponse(object, xmlWriter);
            xmlWriter.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Object var9_7 = null;
            if (XmlRpc.debug) {
                System.out.println("Spent " + (System.currentTimeMillis() - l) + " millis encoding response");
            }
            return byArray;
        }
        catch (Throwable throwable) {
            block4: {
                Object var9_8 = null;
                if (!XmlRpc.debug) break block4;
                System.out.println("Spent " + (System.currentTimeMillis() - l) + " millis encoding response");
            }
            throw throwable;
        }
    }

    public byte[] processException(Exception exception, String string) {
        if (XmlRpc.debug) {
            exception.printStackTrace();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlWriter xmlWriter = null;
        try {
            xmlWriter = new XmlWriter((OutputStream)byteArrayOutputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("XmlRpcServer attempted to use unsupported encoding: " + unsupportedEncodingException);
        }
        catch (IOException iOException) {
            System.err.println("XmlRpcServer experienced I/O error writing error response: " + iOException);
        }
        String string2 = exception.toString();
        int n = exception instanceof XmlRpcException ? ((XmlRpcException)exception).code : 0;
        try {
            this.writeError(n, string2, xmlWriter);
            xmlWriter.flush();
        }
        catch (Exception exception2) {
            System.err.println("Unable to send error response to client: " + exception2);
        }
        return xmlWriter != null ? byteArrayOutputStream.toByteArray() : EMPTY_BYTE_ARRAY;
    }

    void writeResponse(Object object, XmlWriter xmlWriter) throws XmlRpcException, IOException {
        xmlWriter.startElement("methodResponse");
        xmlWriter.startElement("params");
        xmlWriter.startElement("param");
        xmlWriter.writeObject(object);
        xmlWriter.endElement("param");
        xmlWriter.endElement("params");
        xmlWriter.endElement("methodResponse");
    }

    void writeError(int n, String string, XmlWriter xmlWriter) throws XmlRpcException, IOException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("faultCode", new Integer(n));
        hashtable.put("faultString", string);
        xmlWriter.startElement("methodResponse");
        xmlWriter.startElement("fault");
        xmlWriter.writeObject(hashtable);
        xmlWriter.endElement("fault");
        xmlWriter.endElement("methodResponse");
    }
}

