/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import ca.sqlpower.util.Recurrence;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class Scheduler {
    private static final Logger logger = Logger.getLogger(Scheduler.class);
    protected static List schedule = new LinkedList();
    protected static Date baseDate = new Date();
    protected static Thread schedulerThread = new SchedulerThread();

    protected Scheduler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleTask(Recurrence recurrence, Runnable task) {
        List list = schedule;
        synchronized (list) {
            Date firstOccurrence = recurrence.nextOccurrence(baseDate);
            if (firstOccurrence == null) {
                logger.debug((Object)"Not scheduling new task because it has no more occurrences");
                return;
            }
            if (firstOccurrence.getTime() < System.currentTimeMillis()) {
                logger.debug((Object)"Newly scheduled task occurs after base date but before now.  Updating base date.");
                baseDate = new Date();
            }
            schedule.add(0, new ScheduledTask(recurrence, task));
            Collections.sort(schedule);
            schedulerThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledTask unscheduleTask(ScheduledTask task) {
        List list = schedule;
        synchronized (list) {
            Iterator it = schedule.iterator();
            while (it.hasNext()) {
                ScheduledTask st = (ScheduledTask)it.next();
                if (st.task != task) continue;
                it.remove();
                return task;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getScheduledTasks() {
        List list = schedule;
        synchronized (list) {
            return Collections.unmodifiableList(schedule);
        }
    }

    public static Date getBaseDate() {
        return baseDate;
    }

    static {
        schedulerThread.start();
    }

    public static class ScheduledTask {
        public Recurrence recurrence;
        public Runnable task;

        public ScheduledTask(Recurrence recurrence, Runnable task) {
            this.recurrence = recurrence;
            this.task = task;
        }

        public int compareTo(Object other) {
            ScheduledTask otherTask = (ScheduledTask)other;
            Date thisNextOccurrence = this.recurrence.nextOccurrence(baseDate);
            Date otherNextOccurrence = otherTask.recurrence.nextOccurrence(baseDate);
            if (thisNextOccurrence == null && otherNextOccurrence == null) {
                return 0;
            }
            if (thisNextOccurrence == null) {
                return 1;
            }
            if (otherNextOccurrence == null) {
                return -1;
            }
            return (int)(thisNextOccurrence.getTime() - otherNextOccurrence.getTime());
        }

        public boolean equals(Object other) {
            ScheduledTask otherTask = (ScheduledTask)other;
            Date thisNextOccurrence = this.recurrence.nextOccurrence(baseDate);
            Date otherNextOccurrence = otherTask.recurrence.nextOccurrence(baseDate);
            if (thisNextOccurrence == null && otherNextOccurrence == null) {
                return true;
            }
            if (thisNextOccurrence == null) {
                return false;
            }
            if (otherNextOccurrence == null) {
                return false;
            }
            return thisNextOccurrence.getTime() == otherNextOccurrence.getTime();
        }
    }

    protected static class SchedulerThread
    extends Thread {
        public SchedulerThread() {
            super("SQLPower Cron");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Date wakeup = null;
            ScheduledTask nextTask = null;
            while (true) {
                try {
                    List list = schedule;
                    synchronized (list) {
                        if (!schedule.isEmpty()) {
                            nextTask = (ScheduledTask)schedule.get(0);
                            wakeup = nextTask.recurrence.nextOccurrence(baseDate);
                        }
                    }
                    long sleepMillis = 0L;
                    if (wakeup != null) {
                        sleepMillis = wakeup.getTime() - System.currentTimeMillis();
                    }
                    logger.debug((Object)("Sleeping " + (wakeup == null ? "indefinitely" : wakeup.toString())));
                    try {
                        this.join(sleepMillis);
                    }
                    catch (InterruptedException e) {
                        logger.debug((Object)"Received an interrupt while sleeping");
                    }
                    wakeup = new Date();
                    List list2 = schedule;
                    synchronized (list2) {
                        if (!schedule.isEmpty()) {
                            nextTask = (ScheduledTask)schedule.get(0);
                            Date nextTime = nextTask.recurrence.nextOccurrence();
                            while (nextTime != null && nextTime.getTime() <= System.currentTimeMillis()) {
                                try {
                                    logger.debug((Object)"Starting to run scheduled task");
                                    nextTask.task.run();
                                }
                                catch (Exception e) {
                                    logger.error((Object)"Scheduled task threw an exception", (Throwable)e);
                                }
                                baseDate = nextTime;
                                Collections.sort(schedule);
                                nextTask = (ScheduledTask)schedule.get(0);
                                nextTime = nextTask.recurrence.nextOccurrence();
                            }
                        }
                        continue;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Unexpected exception in scheduler thread", (Throwable)e);
                    return;
                }
                finally {
                    logger.error((Object)"SchedulerThread.run() is exiting!");
                    continue;
                }
                break;
            }
        }
    }
}

