/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DeepSubtypeAnalysis;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;

public class ComparatorIdiom
extends PreorderVisitor
implements Detector {
    BugReporter bugReporter;

    public ComparatorIdiom(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void visit(JavaClass obj) {
        try {
            if (Repository.instanceOf((JavaClass)obj, (String)"java.util.Comparator") && !ClassName.isAnonymous((String)this.getClassName()) && !Repository.instanceOf((JavaClass)obj, (String)"java.io.Serializable")) {
                int priority = 2;
                if (obj.isInterface() || obj.isAbstract()) {
                    priority = 3;
                } else {
                    int lastDollar;
                    double easilySerializable = 1.0;
                    Field[] arr$ = obj.getFields();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Field f = arr$[i$];
                        try {
                            String signature = f.getSignature();
                            char firstChar = signature.charAt(0);
                            if (firstChar != 'L' && firstChar != '[') continue;
                            easilySerializable *= DeepSubtypeAnalysis.isDeepSerializable((String)signature);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            easilySerializable = 0.0;
                            break;
                        }
                    }
                    if (easilySerializable < 0.9) {
                        priority = 3;
                    }
                    if ((lastDollar = this.getClassName().lastIndexOf(36)) > 0 && Character.isDigit(this.getClassName().charAt(lastDollar + 1))) {
                        priority = 3;
                    }
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_COMPARATOR_SHOULD_BE_SERIALIZABLE", priority).addClass((PreorderVisitor)this));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void report() {
    }
}

