/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.wizards.CheckoutWizard;

public class CheckoutWizardProjectPage
extends WizardPage {
    private Button defaultButton;
    private Label locationLabel;
    private Text locationText;
    private Button browseButton;

    public CheckoutWizardProjectPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(768));
        this.defaultButton = new Button(outerContainer, 32);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.defaultButton.setLayoutData((Object)data);
        this.defaultButton.setText(Policy.bind("CheckoutWizardProjectPage.default"));
        this.defaultButton.setSelection(true);
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWizardProjectPage.this.setLocationEnablement();
                if (!CheckoutWizardProjectPage.this.defaultButton.getSelection()) {
                    CheckoutWizardProjectPage.this.locationText.selectAll();
                    CheckoutWizardProjectPage.this.locationText.setFocus();
                }
                CheckoutWizardProjectPage.this.setPageComplete();
            }
        });
        this.locationLabel = new Label(outerContainer, 0);
        this.locationLabel.setText(Policy.bind("CheckoutWizardProjectPage.location"));
        this.locationText = new Text(outerContainer, 2048);
        data = new GridData();
        data.widthHint = 300;
        this.locationText.setLayoutData((Object)data);
        this.setLocation();
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CheckoutWizardProjectPage.this.setPageComplete();
            }
        });
        this.browseButton = new Button(outerContainer, 8);
        this.browseButton.setText(Policy.bind("CheckoutWizardProjectPage.browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(CheckoutWizardProjectPage.this.getShell());
                dialog.setMessage(Policy.bind("CheckoutInto.message"));
                String directory = dialog.open();
                if (directory != null) {
                    CheckoutWizardProjectPage.this.locationText.setText(directory);
                }
            }
        });
        this.setLocationEnablement();
        this.setMessage(Policy.bind("CheckoutWizardProjectPage.text"));
        this.setControl((Control)outerContainer);
    }

    private void setLocationEnablement() {
        this.locationLabel.setEnabled(!this.defaultButton.getSelection());
        this.locationText.setEnabled(!this.defaultButton.getSelection());
        this.browseButton.setEnabled(!this.defaultButton.getSelection());
    }

    private void setPageComplete() {
        this.setPageComplete(this.defaultButton.getSelection() || this.locationText.getText().trim().length() > 0);
    }

    public void setLocation() {
        this.locationText.setText(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
    }

    public String getLocation() {
        if (this.locationText == null) {
            CheckoutWizard wizard = (CheckoutWizard)this.getWizard();
            return String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + File.separator + wizard.getProjectName();
        }
        return this.locationText.getText().trim();
    }

    public String getCanonicalLocation() {
        return this.normalizeCase(this.getLocation());
    }

    private String normalizeCase(String location) {
        String caseFixed;
        File dir = new File(location);
        String original = dir.getAbsolutePath();
        try {
            caseFixed = dir.getCanonicalPath();
        }
        catch (IOException iOException) {
            return location;
        }
        if (caseFixed.equalsIgnoreCase(original)) {
            return caseFixed;
        }
        return location;
    }
}

