/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLBindingElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLCommonElement;

public class WSDLServiceElement
extends WSDLCommonElement {
    private Service service_;

    public WSDLServiceElement(String name, Model model, Service service) {
        super(name, model);
        this.setService(service);
    }

    public void setService(Service service) {
        this.service_ = service;
        this.setDocumentation(service.getDocumentationElement());
    }

    public Service getService() {
        return this.service_;
    }

    public String getAddressLocation(Binding binding) {
        Map ports = this.service_.getPorts();
        Iterator i = ports.values().iterator();
        while (i.hasNext()) {
            Port port = (Port)i.next();
            if (!port.getBinding().getQName().equals(binding.getQName())) continue;
            List extensibilityElements = port.getExtensibilityElements();
            Iterator j = extensibilityElements.iterator();
            while (j.hasNext()) {
                ExtensibilityElement element = (ExtensibilityElement)j.next();
                if (element instanceof SOAPAddress) {
                    SOAPAddress soapAddress = (SOAPAddress)element;
                    return soapAddress.getLocationURI();
                }
                if (!(element instanceof HTTPAddress)) continue;
                HTTPAddress httpAddress = (HTTPAddress)element;
                return httpAddress.getLocationURI();
            }
        }
        return null;
    }

    public void buildModel() {
        if (this.service_ != null) {
            Map ports = this.service_.getPorts();
            HashMap<QName, Binding> bindings = new HashMap<QName, Binding>();
            Iterator it = ports.values().iterator();
            while (it.hasNext()) {
                Port port = (Port)it.next();
                Binding binding = port.getBinding();
                if (binding.getPortType() == null) continue;
                bindings.put(binding.getQName(), binding);
            }
            WSDLBindingElement[] wsdlBindingElements = new WSDLBindingElement[this.getNumberOfElements("relWSDLBinding")];
            Enumeration e = this.getElements("relWSDLBinding");
            int i = 0;
            while (i < wsdlBindingElements.length) {
                wsdlBindingElements[i] = (WSDLBindingElement)((Object)e.nextElement());
                ++i;
            }
            int j = 0;
            while (j < wsdlBindingElements.length) {
                QName qname = wsdlBindingElements[j].getBinding().getQName();
                Binding binding = (Binding)bindings.get(qname);
                if (binding != null) {
                    bindings.remove(qname);
                    wsdlBindingElements[j].setBinding(binding);
                    wsdlBindingElements[j].buildModel();
                } else {
                    this.disconnect((Element)wsdlBindingElements[j], "relWSDLBinding");
                }
                ++j;
            }
            Iterator it2 = bindings.values().iterator();
            while (it2.hasNext()) {
                Binding binding = (Binding)it2.next();
                WSDLBindingElement wsdlBindingElement = new WSDLBindingElement(binding.getQName().getLocalPart(), this.getModel(), binding);
                this.connect((Element)wsdlBindingElement, "relWSDLBinding", "owner");
                wsdlBindingElement.buildModel();
            }
        }
    }
}

