/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.actions;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.model.ModelMessages;
import org.eclipse.ltk.internal.ui.refactoring.model.RefactoringDescriptorSynchronizationProxy;
import org.eclipse.ltk.internal.ui.refactoring.model.RefactoringHistoryMergeWizard;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.ui.PlatformUI;

public final class AcceptRefactoringsAction
extends Action {
    private static final int SIZING_WIZARD_HEIGHT = 520;
    private static final int SIZING_WIZARD_WIDTH = 470;
    private final ISynchronizationContext fContext;
    private RefactoringDescriptorProxy[] fProxies = null;
    private final Shell fShell;

    public AcceptRefactoringsAction(ISynchronizationContext context, Shell shell) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)shell);
        this.fContext = context;
        this.fShell = shell;
        this.setText(ModelMessages.AcceptRefactoringsAction_title);
        this.setToolTipText(ModelMessages.AcceptRefactoringsAction_tool_tip);
        this.setDescription(ModelMessages.AcceptRefactoringsAction_description);
    }

    public boolean isEnabled() {
        if (this.fProxies != null && this.fProxies.length > 0) {
            int index = 0;
            while (index < this.fProxies.length) {
                RefactoringDescriptorSynchronizationProxy proxy;
                if (this.fProxies[index] instanceof RefactoringDescriptorSynchronizationProxy && (proxy = (RefactoringDescriptorSynchronizationProxy)this.fProxies[index]).getDirection() == 512) {
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    public void run() {
        if (this.fProxies != null && this.fProxies.length > 0) {
            RefactoringHistoryAcceptWizard wizard = new RefactoringHistoryAcceptWizard();
            int result = 0;
            try {
                WizardDialog dialog = new WizardDialog(this.fShell, (IWizard)wizard);
                IProject project = null;
                HashSet<RefactoringDescriptorSynchronizationProxy> proxies = new HashSet<RefactoringDescriptorSynchronizationProxy>();
                int index = 0;
                while (index < this.fProxies.length) {
                    String name;
                    RefactoringDescriptorSynchronizationProxy proxy;
                    if (this.fProxies[index] instanceof RefactoringDescriptorSynchronizationProxy && (proxy = (RefactoringDescriptorSynchronizationProxy)this.fProxies[index]).getDirection() == 512) {
                        proxies.add(proxy);
                    }
                    if ((name = this.fProxies[index].getProject()) != null && !"".equals(name)) {
                        project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                    }
                    ++index;
                }
                wizard.setConfiguration(new RefactoringHistoryAcceptConfiguration(project));
                wizard.setInput((RefactoringHistory)new RefactoringHistoryImplementation(proxies.toArray(new RefactoringDescriptorProxy[proxies.size()])));
                dialog.create();
                dialog.getShell().setSize(Math.max(470, dialog.getShell().getSize().x), 520);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jdt.ui.refactoring_accept_page");
                result = dialog.open();
            }
            finally {
                if (result != 1 && this.fContext instanceof IMergeContext) {
                    IMergeContext iMergeContext = (IMergeContext)this.fContext;
                    wizard.resolveConflicts(iMergeContext);
                }
            }
        }
    }

    public void setRefactoringDescriptors(RefactoringDescriptorProxy[] proxies) {
        Assert.isNotNull((Object)proxies);
        this.fProxies = proxies;
    }

    private static final class RefactoringHistoryAcceptConfiguration
    extends RefactoringHistoryControlConfiguration {
        public RefactoringHistoryAcceptConfiguration(IProject project) {
            super(project, false, false);
        }

        public String getProjectPattern() {
            return ModelMessages.AcceptRefactoringsAction_wizard_project_pattern;
        }

        public String getWorkspaceCaption() {
            return ModelMessages.AcceptRefactoringsAction_wizard_workspace_caption;
        }
    }

    private static final class RefactoringHistoryAcceptWizard
    extends RefactoringHistoryMergeWizard {
        public RefactoringHistoryAcceptWizard() {
            super(RefactoringUIMessages.RefactoringWizard_refactoring, ModelMessages.AcceptRefactoringsAction_wizard_title, ModelMessages.AcceptRefactoringsAction_wizard_description);
        }
    }
}

