/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.RemoveFromViewAction;
import org.eclipse.team.internal.ui.synchronize.ConfigureRefreshScheduleDialog;
import org.eclipse.team.internal.ui.synchronize.IRefreshable;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionBars;

public class RefreshActionContribution
extends SynchronizePageActionGroup {
    private Action configureSchedule;
    private Action refreshSelectionAction;
    private RemoveFromViewAction removeFromViewAction;

    public void initialize(ISynchronizePageConfiguration configuration) {
        super.initialize(configuration);
        final ISynchronizePageSite site = configuration.getSite();
        final ModelSynchronizeParticipant participant = (ModelSynchronizeParticipant)configuration.getParticipant();
        if (participant.doesSupportSynchronize()) {
            this.refreshSelectionAction = new Action(){

                public void run() {
                    IStructuredSelection selection = (IStructuredSelection)site.getSelectionProvider().getSelection();
                    ResourceMapping[] mappings = Utils.getResourceMappings(selection.toArray());
                    participant.refresh(site.getWorkbenchSite(), mappings);
                }
            };
            Utils.initAction((IAction)this.refreshSelectionAction, "action.refreshWithRemote.");
            this.refreshSelectionAction.setActionDefinitionId("org.eclipse.team.ui.synchronizeLast");
            this.refreshSelectionAction.setId("org.eclipse.team.ui.synchronizeLast");
            Object o = participant.getAdapter(IRefreshable.class);
            if (o instanceof IRefreshable) {
                final IRefreshable refreshable = (IRefreshable)o;
                this.configureSchedule = new Action(){

                    public void run() {
                        ConfigureRefreshScheduleDialog d = new ConfigureRefreshScheduleDialog(site.getShell(), refreshable.getRefreshSchedule());
                        d.setBlockOnOpen(false);
                        d.open();
                    }
                };
                Utils.initAction((IAction)this.configureSchedule, "action.configureSchedulel.");
            }
        }
        this.removeFromViewAction = new RemoveFromViewAction(configuration);
    }

    public void fillContextMenu(IMenuManager manager) {
        if (this.findGroup((IContributionManager)manager, "synchronize") != null && this.findGroup((IContributionManager)manager, "navigate") != null) {
            this.appendToGroup((IContributionManager)manager, "navigate", (IAction)this.refreshSelectionAction);
            this.appendToGroup((IContributionManager)manager, "navigate", (IAction)this.removeFromViewAction);
        } else {
            this.appendToGroup((IContributionManager)manager, "synchronize", (IAction)this.refreshSelectionAction);
            this.appendToGroup((IContributionManager)manager, "synchronize", (IAction)this.removeFromViewAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (actionBars != null) {
            IMenuManager menu = actionBars.getMenuManager();
            if (this.findGroup((IContributionManager)menu, "synchronize") != null && this.findGroup((IContributionManager)menu, "preferences") != null) {
                this.appendToGroup((IContributionManager)menu, "preferences", (IAction)this.configureSchedule);
            } else {
                this.appendToGroup((IContributionManager)menu, "synchronize", (IAction)this.configureSchedule);
            }
        }
    }
}

