/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath;

import gnu.classpath.ServiceProviderLoadingAction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class ServiceFactory {
    private static final Logger LOGGER = Logger.getLogger("gnu.classpath");

    private ServiceFactory() {
    }

    public static Iterator lookupProviders(Class clazz, ClassLoader classLoader) {
        Enumeration enumeration;
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        String string = "META-INF/services/" + clazz.getName();
        try {
            enumeration = classLoader.getResources(string);
        }
        catch (IOException iOException) {
            ServiceFactory.log(Level.WARNING, "cannot access {0}", string, iOException);
            return Collections.EMPTY_LIST.iterator();
        }
        return new ServiceIterator(clazz, enumeration, classLoader, AccessController.getContext());
    }

    public static Iterator lookupProviders(Class clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ServiceFactory.lookupProviders(clazz, classLoader);
    }

    static void log(Level level, String string, Object object, Throwable throwable) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        if (object != null && object.getClass().isArray()) {
            logRecord.setParameters((Object[])object);
        } else {
            logRecord.setParameters(new Object[]{object});
        }
        logRecord.setThrown(throwable);
        logRecord.setSourceClassName(ServiceFactory.class$("gnu.classpath.ServiceFactory").getName());
        logRecord.setSourceMethodName("lookupProviders");
        LOGGER.log(logRecord);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class ServiceIterator
    implements Iterator {
        private final Class spi;
        private final Enumeration urls;
        private final ClassLoader loader;
        private final AccessControlContext securityContext;
        private BufferedReader reader;
        private URL currentURL;
        private Object nextProvider;

        ServiceIterator(Class clazz, Enumeration enumeration, ClassLoader classLoader, AccessControlContext accessControlContext) {
            this.spi = clazz;
            this.urls = enumeration;
            this.loader = classLoader;
            this.securityContext = accessControlContext;
            this.nextProvider = this.loadNextServiceProvider();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.nextProvider;
            this.nextProvider = this.loadNextServiceProvider();
            return object;
        }

        public boolean hasNext() {
            return this.nextProvider != null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Object loadNextServiceProvider() {
            if (this.reader == null) {
                this.advanceReader();
            }
            while (this.reader != null) {
                String string;
                try {
                    string = this.reader.readLine();
                }
                catch (IOException iOException) {
                    ServiceFactory.log(Level.WARNING, "IOException upon reading {0}", this.currentURL, iOException);
                    string = null;
                }
                if (string == null) {
                    this.advanceReader();
                    continue;
                }
                if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') continue;
                try {
                    ServiceFactory.log(Level.FINE, "Loading service provider \"{0}\", specified by \"META-INF/services/{1}\" in {2}.", new Object[]{string, this.spi.getName(), this.currentURL}, null);
                    return AccessController.doPrivileged(new ServiceProviderLoadingAction(this.spi, string, this.loader), this.securityContext);
                }
                catch (Exception exception) {
                    String string2 = "Cannot load service provider class \"{0}\", specified by \"META-INF/services/{1}\" in {2}";
                    if (exception instanceof PrivilegedActionException && exception.getCause() instanceof ClassCastException) {
                        string2 = "Service provider class \"{0}\" is not an instance of \"{1}\". Specified by \"META-INF/services/{1}\" in {2}.";
                    }
                    ServiceFactory.log(Level.WARNING, string2, new Object[]{string, this.spi.getName(), this.currentURL}, exception);
                    continue;
                }
                break;
            }
            return null;
        }

        private void advanceReader() {
            do {
                if (this.reader != null) {
                    try {
                        this.reader.close();
                        ServiceFactory.log(Level.FINE, "closed {0}", this.currentURL, null);
                    }
                    catch (Exception exception) {
                        ServiceFactory.log(Level.WARNING, "cannot close {0}", this.currentURL, exception);
                    }
                    this.reader = null;
                    this.currentURL = null;
                }
                if (!this.urls.hasMoreElements()) {
                    return;
                }
                this.currentURL = (URL)this.urls.nextElement();
                try {
                    this.reader = new BufferedReader(new InputStreamReader(this.currentURL.openStream(), "UTF-8"));
                    ServiceFactory.log(Level.FINE, "opened {0}", this.currentURL, null);
                }
                catch (Exception exception) {
                    ServiceFactory.log(Level.WARNING, "cannot open {0}", this.currentURL, exception);
                }
            } while (this.reader == null);
        }
    }
}

