#!/bin/sh
echo 'name: HTTP
version: 4000.0.9
id: HTTP-4000.0.9-beb33b188e291bf7d33f8049bd5a51fc

license: BSD3
copyright: Copyright (c) 2002, Warrick Gray
           Copyright (c) 2002-2005, Ian Lynagh
           Copyright (c) 2003-2006, Bjorn Bringert
           Copyright (c) 2004, Andre Furtado
           Copyright (c) 2004, Ganesh Sittampalam
           Copyright (c) 2004-2005, Dominic Steinitz
           Copyright 2007 Robin Bate Boerop
           Copyright 2008- Sigbjorn Finne
maintainer: Sigbjorn Finne <sigbjorn.finne@gmail.com>
stability:
homepage: http://projects.haskell.org/http/
package-url:
description: The HTTP package supports client-side web programming in Haskell. It lets you set up
             HTTP connections, transmitting requests and processing the responses coming back, all
             from within the comforts of Haskell. It'\''s dependent on the network package to operate,
             but other than that, the implementation is all written in Haskell.
             .
             A basic API for issuing single HTTP requests + receiving responses is provided. On top
             of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
             it taking care of handling the management of persistent connections, proxies,
             state (cookies) and authentication credentials required to handle multi-step
             interactions with a web server.
             .
             The representation of the bytes flowing across is extensible via the use of a type class,
             letting you pick the representation of requests and responses that best fits your use.
             Some pre-packaged, common instances are provided for you (@ByteString@, @String@.)
             .
             Here'\''s an example use:
             .
             >
             >    do
             >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
             >              -- fetch document and return it (as a '\''String'\''.)
             >      fmap (take 100) (getResponseBody rsp)
             >
             >    do
             >      rsp <- Network.Browser.browse $ do
             >               setAllowRedirects True -- handle HTTP redirects
             >               request $ getRequest "http://google.com/"
             >      fmap (take 100) (getResponseBody rsp)
             >
             .
             Git repository available at <git://code.galois.com/HTTPbis.git>
category: Network
author: Warrick Gray <warrick.gray@hotmail.com>
exposed: True
exposed-modules: Network.BufferType Network.Stream
                 Network.StreamDebugger Network.StreamSocket Network.TCP
                 Network.HTTP Network.HTTP.Headers Network.HTTP.Base
                 Network.HTTP.Stream Network.HTTP.Auth Network.HTTP.Cookie
                 Network.HTTP.Proxy Network.HTTP.HandleStream Network.Browser
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5
                Network.HTTP.MD5Aux Network.HTTP.Utils
import-dirs: /usr/local/lib/HTTP-4000.0.9/ghc-6.12.3
library-dirs: /usr/local/lib/HTTP-4000.0.9/ghc-6.12.3
hs-libraries: HSHTTP-4000.0.9
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.3.0.1-438000c197b51c147f229b54edbf632e
         base-3.0.3.2-260693a92016991a03206b5a55f6a411
         bytestring-0.9.1.7-41dd05a497806d68d10ffae5438a0632
         mtl-1.1.0.2-9e35d291e0ab20c6aa18823de23bc2de
         network-2.2.1.7-194f6443d68f3341443f88ff72345c9e
         old-time-1.0.0.5-99a656bc4f807d3640e245d60c3d290a
         parsec-2.1.0.1-2ae394a385ce9d23f9dbc30dd0fe7b8e
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/HTTP-4000.0.9/html/HTTP.haddock
haddock-html: /usr/local/share/doc/HTTP-4000.0.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
