/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicElementSettings;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicPropertyDialog;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class DynamicPropertyFix
implements IntentionAction {
    private final GrReferenceExpression myReferenceExpression;
    private final GrArgumentLabel myArgumentLabel;
    private final PsiClass myTargetClass;

    public DynamicPropertyFix(GrReferenceExpression referenceExpression) {
        this.myReferenceExpression = referenceExpression;
        this.myArgumentLabel = null;
        this.myTargetClass = null;
    }

    public DynamicPropertyFix(GrArgumentLabel argumentLabel, PsiClass targetClass) {
        this.myArgumentLabel = argumentLabel;
        this.myReferenceExpression = null;
        this.myTargetClass = targetClass;
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("add.dynamic.property", this.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicPropertyFix.getText must not return null");
        }
        return string;
    }

    private String getName() {
        if (this.myReferenceExpression != null) {
            return this.myReferenceExpression.getName();
        }
        return this.myArgumentLabel.getName();
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("add.dynamic.element", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicPropertyFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicPropertyFix.isAvailable must not be null");
        }
        return !(this.myReferenceExpression != null && !this.myReferenceExpression.isValid() || this.myArgumentLabel != null && !this.myArgumentLabel.isValid());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicPropertyFix.invoke must not be null");
        }
        DynamicPropertyDialog dialog = this.myReferenceExpression != null ? new DynamicPropertyDialog(this.myReferenceExpression) : new DynamicPropertyDialog(this.myArgumentLabel, this.myTargetClass);
        dialog.show();
    }

    public void invoke(Project project) throws IncorrectOperationException {
        DynamicElementSettings settings = this.myReferenceExpression != null ? QuickfixUtil.createSettings(this.myReferenceExpression) : QuickfixUtil.createSettings(this.myArgumentLabel, this.myTargetClass);
        DynamicManager.getInstance(project).addProperty(settings);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public GrReferenceExpression getReferenceExpression() {
        return this.myReferenceExpression;
    }
}

