/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.gant.GantConfigurable;
import org.jetbrains.plugins.groovy.gant.GantIcons;
import org.jetbrains.plugins.groovy.gant.GantUtils;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;
import org.jetbrains.plugins.groovy.util.GroovyUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GantRunner
extends GroovyScriptRunner {
    @Override
    public boolean isValidModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gant/GantRunner.isValidModule must not be null");
        }
        return GantUtils.isSDKConfiguredToRun(module);
    }

    @Override
    public boolean ensureRunnerConfigured(@Nullable Module module, String confName, Project project) {
        if (GantUtils.getSDKInstallPath(module, project).length() <= 0) {
            int result = Messages.showOkCancelDialog((String)"Gant is not configured. Do you want to configure it?", (String)"Configure Gant SDK", (Icon)GantIcons.GANT_ICON_16x16);
            if (result == 0) {
                ShowSettingsUtil util = ShowSettingsUtil.getInstance();
                util.editConfigurable(project, util.findProjectConfigurable(project, GantConfigurable.class));
            }
            if (GantUtils.getSDKInstallPath(module, project).length() <= 0) {
                return false;
            }
        }
        return true;
    }

    private static String getGantConfPath(String gantHome) {
        String confPath = FileUtil.toSystemDependentName((String)(gantHome + "/conf/gant-starter.conf"));
        if (new File(confPath).exists()) {
            return confPath;
        }
        return GantRunner.getConfPath(gantHome);
    }

    @Override
    public void configureCommandLine(JavaParameters params, @Nullable Module module, boolean tests, VirtualFile script, GroovyScriptRunConfiguration configuration) throws CantRunException {
        String antHome;
        String groovyHome;
        String gantHome = GantUtils.getSDKInstallPath(module, configuration.getProject());
        File[] groovyJars = GroovyUtils.getFilesInDirectoryByPattern(gantHome + "/lib/", "groovy-all-(.*)\\.jar");
        if (groovyJars.length > 0) {
            params.getClassPath().add(groovyJars[0].getAbsolutePath());
        } else if (module != null && (groovyHome = LibrariesUtil.getGroovyHomePath(module)) != null) {
            for (File groovyLibJar : GroovyUtils.getFilesInDirectoryByPattern(groovyHome + "/lib/", ".*\\.jar")) {
                params.getClassPath().add(groovyLibJar);
            }
        }
        GantRunner.setToolsJar(params);
        GantRunner.setGroovyHome(params, gantHome);
        String confPath = GantRunner.getGantConfPath(gantHome);
        params.getVMParametersList().add("-Dgroovy.starter.conf=" + confPath);
        params.getVMParametersList().addParametersString(configuration.vmParams);
        params.setMainClass("org.codehaus.groovy.tools.GroovyStarter");
        params.getProgramParametersList().add("--conf");
        params.getProgramParametersList().add(confPath);
        GantRunner.addClasspathFromRootModel(module, tests, params);
        if (gantHome.contains("grails")) {
            params.getClassPath().addAllFiles(GroovyUtils.getFilesInDirectoryByPattern(gantHome + "/lib", ".*\\.jar"));
        }
        if (StringUtil.isEmpty((String)(antHome = System.getenv("ANT_HOME")))) {
            antHome = gantHome;
        }
        params.getVMParametersList().add("-Dant.home=" + antHome);
        params.getVMParametersList().add("-Dgant.home=" + gantHome + "");
        params.getProgramParametersList().add("--main");
        params.getProgramParametersList().add("gant.Gant");
        params.getProgramParametersList().add("--file");
        params.getProgramParametersList().add(FileUtil.toSystemDependentName((String)configuration.scriptPath));
        params.getProgramParametersList().addParametersString(configuration.scriptParams);
        if (configuration.isDebugEnabled) {
            params.getProgramParametersList().add("--debug");
        }
    }
}

