/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

class RemoveParenthesesFromMethodPredicate
implements PsiElementPredicate {
    RemoveParenthesesFromMethodPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof GrMethodCallExpression)) {
            return false;
        }
        GrMethodCallExpression methodCallExpression = (GrMethodCallExpression)element;
        GrArgumentList argumentList = methodCallExpression.getArgumentList();
        if (argumentList == null) {
            return false;
        }
        GrExpression[] arguments = argumentList.getExpressionArguments();
        if (arguments.length == 0) {
            return false;
        }
        GrExpression firstArg = arguments[0];
        if (firstArg instanceof GrListOrMap) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (firstArg instanceof GrMethodCallExpression) {
            GrMethodCallExpression call = (GrMethodCallExpression)firstArg;
            GrExpression invokedExpression = call.getInvokedExpression();
            if (invokedExpression instanceof GrReferenceExpression) {
                invokedExpression = this.getDeepestInvocationExpression(invokedExpression);
            }
            if (invokedExpression instanceof GrParenthesizedExpression) {
                return false;
            }
        }
        return parent instanceof GrOpenBlock || parent instanceof GroovyFile || parent instanceof GrClosableBlock;
    }

    private GrExpression getDeepestInvocationExpression(GrExpression invokedExpression) {
        if (invokedExpression instanceof GrReferenceExpression) {
            GrReferenceExpression refElement = (GrReferenceExpression)invokedExpression;
            return this.getDeepestInvocationExpression(refElement.getQualifierExpression());
        }
        return invokedExpression;
    }
}

